/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.blacktie.administration;

import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.blacktie.administration.BlacktieAdminServiceMBean;
import org.jboss.blacktie.administration.QueueReaper;
import org.jboss.blacktie.administration.core.AdministrationProxy;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlacktieAdminService
implements BlacktieAdminServiceMBean {
    private static final Logger log = LogManager.getLogger(BlacktieAdminService.class);
    private QueueReaper reaper;
    private AdministrationProxy administrationProxy;

    @Override
    public void start() throws Exception {
        this.administrationProxy = new AdministrationProxy();
        this.reaper = new QueueReaper(this.administrationProxy.getBeanServerConnection());
        this.reaper.startThread();
        log.info((Object)"Admin Server Started");
    }

    @Override
    public void stop() throws Exception {
        this.reaper.stopThread();
        this.administrationProxy.close();
        log.info((Object)"Admin Server Stopped");
    }

    @Override
    public String getDomainName() {
        return this.administrationProxy.getDomainName();
    }

    @Override
    public String getSoftwareVersion() {
        return this.administrationProxy.getSoftwareVersion();
    }

    @Override
    public Boolean getDomainStatus() {
        return this.administrationProxy.getDomainStatus();
    }

    @Override
    public Boolean pauseDomain() {
        return this.administrationProxy.pauseDomain();
    }

    @Override
    public Boolean resumeDomain() {
        return this.administrationProxy.resumeDomain();
    }

    @Override
    public List<String> getServerList() {
        return this.administrationProxy.getServerList();
    }

    @Override
    public List<String> listRunningServers() {
        return this.administrationProxy.listRunningServers();
    }

    @Override
    public List<Integer> listRunningInstanceIds(String serverName) {
        return this.administrationProxy.listRunningInstanceIds(serverName);
    }

    @Override
    public Element getServersStatus() {
        return this.administrationProxy.getServersStatus();
    }

    @Override
    public Element listServiceStatus(String serverName, String serviceName) {
        return this.administrationProxy.listServiceStatus(serverName, serviceName);
    }

    @Override
    public Boolean advertise(String serverName, String serviceName) {
        return this.administrationProxy.advertise(serverName, serviceName);
    }

    @Override
    public Boolean unadvertise(String serverName, String serviceName) {
        return this.administrationProxy.unadvertise(serverName, serviceName);
    }

    @Override
    public Boolean shutdown(String serverName, int id) {
        return this.administrationProxy.shutdown(serverName, id);
    }

    @Override
    public long getServiceCounterById(String serverName, int id, String serviceName) {
        return this.administrationProxy.getServiceCounterById(serverName, id, serviceName);
    }

    @Override
    public long getServiceCounter(String serverName, String serviceName) {
        return this.administrationProxy.getServiceCounter(serverName, serviceName);
    }

    @Override
    public Boolean reloadDomain() {
        return this.administrationProxy.reloadDomain();
    }

    @Override
    public Boolean reloadServer(String serverName) {
        return this.administrationProxy.reloadServer(serverName);
    }

    @Override
    public Element listServiceStatusById(String serverName, int id, String serviceName) {
        return this.administrationProxy.listServiceStatusById(serverName, id, serviceName);
    }

    @Override
    public String getResponseTimeById(String serverName, int id, String serviceName) {
        return this.administrationProxy.getResponseTimeById(serverName, id, serviceName);
    }

    @Override
    public String getResponseTime(String serverName, String serviceName) {
        return this.administrationProxy.getResponseTime(serverName, serviceName);
    }

    @Override
    public int getQueueDepth(String serverName, String serviceName) {
        return this.administrationProxy.getQueueDepth(serverName, serviceName);
    }

    @Override
    public String getServerName(String serviceName) {
        return this.administrationProxy.getServerName(serviceName);
    }

    @Override
    public long getErrorCounter(String serverName, String serviceName) {
        return this.administrationProxy.getErrorCounter(serverName, serviceName);
    }

    @Override
    public long getErrorCounterById(String serverName, int id, String serviceName) {
        return this.administrationProxy.getErrorCounterById(serverName, id, serviceName);
    }

    @Override
    public String getServerVersionById(String serverName, int id) {
        return this.administrationProxy.getServerVersionById(serverName, id);
    }
}

