/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.blacktie.administration;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.blacktie.administration.BlacktieStompAdministrationService;
import org.jboss.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.blacktie.jatmibroker.core.conf.XMLEnvHandler;
import org.jboss.blacktie.jatmibroker.core.conf.XMLParser;
import org.xml.sax.helpers.DefaultHandler;

public class QueueReaper
implements Runnable {
    private static final Logger log = LogManager.getLogger(QueueReaper.class);
    private long interval = -1L;
    private Thread thread = new Thread(this);
    private boolean run;
    private MBeanServerConnection beanServerConnection;
    private Properties prop;

    public QueueReaper(MBeanServerConnection conn) throws ConfigurationException {
        this.thread.setDaemon(true);
        this.thread.setPriority(1);
        this.beanServerConnection = conn;
        this.prop = new Properties();
        XMLEnvHandler handler = new XMLEnvHandler(this.prop);
        XMLParser xmlenv = new XMLParser((DefaultHandler)handler, "btconfig.xsd");
        xmlenv.parse("btconfig.xml");
        this.interval = Integer.parseInt(this.prop.getProperty("QueueReaperInterval", "30")) * 1000;
    }

    public void startThread() {
        if (!this.run) {
            this.run = true;
            if (this.thread.isInterrupted()) {
                Thread.interrupted();
            }
            this.thread.start();
        } else {
            log.debug((Object)"Thread already running");
        }
    }

    public void stopThread() {
        if (!this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
        this.run = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            log.warn((Object)("Could not join with reaper: " + e.getMessage()));
        }
    }

    public boolean isRunning() {
        return this.run;
    }

    public void run() {
        while (this.run) {
            try {
                ObjectName objName = new ObjectName("jboss.messaging:service=ServerPeer");
                HashSet dests = (HashSet)this.beanServerConnection.getAttribute(objName, "Destinations");
                for (Destination dest : dests) {
                    if (!(dest instanceof Queue)) continue;
                    String serviceName = ((Queue)dest).getQueueName();
                    serviceName = serviceName.substring(serviceName.indexOf(95) + 1);
                    String server = (String)this.prop.get("blacktie." + serviceName + ".server");
                    long queueReapCheck = System.currentTimeMillis();
                    if ((server != null || serviceName.contains(".")) && this.isCreatedProgrammatically(serviceName).booleanValue() && this.consumerCount(serviceName) == 0) {
                        log.warn((Object)("undeploy service pending for " + serviceName + " as consumer count is 0, will check again in 30 seconds"));
                        Thread.sleep(this.interval);
                        if (this.isOlderThanReapCheck(serviceName, queueReapCheck) && this.consumerCount(serviceName) == 0) {
                            this.undeployQueue(serviceName);
                            log.warn((Object)("undeploy service " + serviceName + " for consumer is 0"));
                            continue;
                        }
                        log.info((Object)("undeploy service not required for " + serviceName));
                        continue;
                    }
                    log.debug((Object)("Could not determine the server for: " + serviceName + " at: " + server));
                }
                log.debug((Object)("Sleeping for " + this.interval + " ms"));
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                log.debug((Object)"Sleeping interrupted");
                this.run = false;
            }
            catch (Exception e) {
                log.error((Object)("run ping thread failed with (will wait for: " + this.interval + " seconds): " + e), (Throwable)e);
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e2) {
                    log.debug((Object)"Sleeping interrupted");
                    this.run = false;
                }
            }
        }
    }

    int consumerCount(String serviceName) throws Exception {
        log.trace((Object)serviceName);
        boolean conversational = false;
        if (!serviceName.startsWith(".")) {
            conversational = (Boolean)this.prop.get("blacktie." + serviceName + ".conversational");
        }
        String prefix = null;
        prefix = conversational ? "BTC_" : "BTR_";
        ObjectName objName = new ObjectName("jboss.messaging.destination:service=Queue,name=" + prefix + serviceName);
        Integer count = (Integer)this.beanServerConnection.getAttribute(objName, "ConsumerCount");
        return count;
    }

    Boolean isCreatedProgrammatically(String serviceName) throws Exception {
        log.trace((Object)serviceName);
        boolean conversational = false;
        if (!serviceName.startsWith(".")) {
            conversational = (Boolean)this.prop.get("blacktie." + serviceName + ".conversational");
        }
        String prefix = null;
        prefix = conversational ? "BTC_" : "BTR_";
        ObjectName objName = new ObjectName("jboss.messaging.destination:service=Queue,name=" + prefix + serviceName);
        return (Boolean)this.beanServerConnection.getAttribute(objName, "CreatedProgrammatically");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOlderThanReapCheck(String serviceName, long queueReapCheck) {
        Hashtable<String, Long> hashtable = BlacktieStompAdministrationService.QUEUE_CREATION_TIMES;
        synchronized (hashtable) {
            boolean toReturn = false;
            Long creationTime = BlacktieStompAdministrationService.QUEUE_CREATION_TIMES.get(serviceName);
            if (creationTime != null) {
                boolean bl = toReturn = creationTime < queueReapCheck;
                if (!toReturn) {
                    log.warn((Object)("New queue will be ignored: " + serviceName));
                }
            }
            return toReturn;
        }
    }

    int undeployQueue(String serviceName) {
        int result = 0;
        try {
            log.trace((Object)serviceName);
            boolean conversational = false;
            if (!serviceName.startsWith(".")) {
                conversational = (Boolean)this.prop.get("blacktie." + serviceName + ".conversational");
            }
            String prefix = null;
            prefix = conversational ? "BTC_" : "BTR_";
            ObjectName objName = new ObjectName("jboss.messaging:service=ServerPeer");
            this.beanServerConnection.invoke(objName, "undeployQueue", new Object[]{prefix + serviceName}, new String[]{"java.lang.String"});
            result = 1;
        }
        catch (Throwable t) {
            log.error((Object)("Could not undeploy queue of " + serviceName), t);
        }
        return result;
    }
}

