/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.blacktie.administration.core;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.blacktie.jatmibroker.core.conf.XMLEnvHandler;
import org.jboss.blacktie.jatmibroker.core.conf.XMLParser;
import org.jboss.blacktie.jatmibroker.xatmi.Buffer;
import org.jboss.blacktie.jatmibroker.xatmi.Connection;
import org.jboss.blacktie.jatmibroker.xatmi.ConnectionException;
import org.jboss.blacktie.jatmibroker.xatmi.ConnectionFactory;
import org.jboss.blacktie.jatmibroker.xatmi.Response;
import org.jboss.blacktie.jatmibroker.xatmi.X_OCTET;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdministrationProxy {
    private static final Logger log = LogManager.getLogger(AdministrationProxy.class);
    private Properties prop = new Properties();
    private JMXConnector c;
    private MBeanServerConnection beanServerConnection;
    private Connection connection;
    private List<String> servers;
    public static Boolean isDomainPause = false;

    public AdministrationProxy() throws IOException, ConfigurationException {
        log.debug((Object)"Administration Proxy");
        XMLEnvHandler handler = new XMLEnvHandler(this.prop);
        XMLParser xmlenv = new XMLParser((DefaultHandler)handler, "btconfig.xsd");
        xmlenv.parse("btconfig.xml");
        this.servers = (List)this.prop.get("blacktie.domain.servers");
        ConnectionFactory cf = ConnectionFactory.getConnectionFactory();
        this.connection = cf.getConnection();
        JMXServiceURL u = new JMXServiceURL((String)this.prop.get("JMXURL"));
        this.c = JMXConnectorFactory.connect(u);
        this.beanServerConnection = this.c.getMBeanServerConnection();
        log.debug((Object)"Created Administration Proxy");
    }

    private Element stringToElement(String s) throws Exception {
        StringReader sreader = new StringReader(s.trim());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document doc = parser.parse(new InputSource(sreader));
        return doc.getDocumentElement();
    }

    private String elementToString(Element element) throws Exception {
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        DOMSource source = new DOMSource(element);
        trans.transform(source, sr);
        return sw.toString();
    }

    private Response callAdminService(String serverName, int id, String command) throws ConnectionException {
        log.trace((Object)"callAdminService");
        int sendlen = command.length() + 1;
        X_OCTET sendbuf = (X_OCTET)this.connection.tpalloc("X_OCTET", null, sendlen);
        sendbuf.setByteArray(command.getBytes());
        String service = "." + serverName + id;
        Response rcvbuf = this.connection.tpcall(service, (Buffer)sendbuf, 0);
        return rcvbuf;
    }

    private Boolean callAdminCommand(String serverName, int id, String command) {
        log.trace((Object)"callAdminCommand");
        try {
            Response buf = this.callAdminService(serverName, id, command);
            if (buf != null) {
                byte[] received = ((X_OCTET)buf.getBuffer()).getByteArray();
                return received[0] == 49;
            }
        }
        catch (ConnectionException e) {
            log.error((Object)("call server " + serverName + " id " + id + " command " + command + " failed with " + e.getTperrno()));
        }
        return false;
    }

    private Boolean advertise(String serverName, int id, String serviceName) {
        log.trace((Object)"advertise");
        String command = "advertise," + serviceName + ",";
        return this.callAdminCommand(serverName, id, command);
    }

    private Boolean unadvertise(String serverName, int id, String serviceName) {
        log.trace((Object)"unadvertise");
        String command = "unadvertise," + serviceName + ",";
        return this.callAdminCommand(serverName, id, command);
    }

    public String getDomainName() {
        log.trace((Object)"getDomainName");
        return this.prop.getProperty("blacktie.domain.name");
    }

    public String getSoftwareVersion() {
        log.trace((Object)"getSoftwareVersion");
        return this.prop.getProperty("blacktie.domain.version");
    }

    public Boolean getDomainStatus() {
        return isDomainPause;
    }

    public Boolean pauseDomain() {
        log.trace((Object)"pauseDomain");
        Boolean result = true;
        List<String> servers = this.listRunningServers();
        for (int i = 0; i < servers.size(); ++i) {
            result = this.pauseServer(servers.get(i)) != false && result != false;
        }
        if (result.booleanValue() && !isDomainPause.booleanValue()) {
            isDomainPause = true;
            log.info((Object)"Domain pause");
        }
        return result;
    }

    public Boolean pauseServer(String serverName) {
        log.trace((Object)"pauseServer");
        Boolean result = true;
        List<Integer> ids = this.listRunningInstanceIds(serverName);
        for (int i = 0; i < ids.size(); ++i) {
            result = this.pauseServerById(serverName, ids.get(i)) != false && result != false;
        }
        return result;
    }

    public Boolean pauseServerById(String serverName, int id) {
        log.trace((Object)"pauseServerById");
        return this.callAdminCommand(serverName, id, "pause");
    }

    public Boolean resumeDomain() {
        log.trace((Object)"resumeDomain");
        Boolean result = true;
        List<String> servers = this.listRunningServers();
        for (int i = 0; i < servers.size(); ++i) {
            result = this.resumeServer(servers.get(i)) != false && result != false;
        }
        if (result.booleanValue() && isDomainPause.booleanValue()) {
            isDomainPause = false;
            log.info((Object)"Domain resume");
        }
        return result;
    }

    public Boolean resumeServer(String serverName) {
        log.trace((Object)"resumeServer");
        Boolean result = true;
        List<Integer> ids = this.listRunningInstanceIds(serverName);
        for (int i = 0; i < ids.size(); ++i) {
            result = this.resumeServerById(serverName, ids.get(i)) != false && result != false;
        }
        return result;
    }

    public Boolean resumeServerById(String serverName, int id) {
        log.trace((Object)"resumeServerById");
        return this.callAdminCommand(serverName, id, "resume");
    }

    public List<String> getServerList() {
        log.trace((Object)"getServerList");
        ArrayList<String> serverList = new ArrayList<String>();
        for (String server : this.servers) {
            serverList.add(server);
        }
        return serverList;
    }

    public List<String> listRunningServers() {
        log.trace((Object)"listRunningServers");
        ArrayList<String> runningServerList = new ArrayList<String>();
        try {
            ObjectName objName = new ObjectName("jboss.messaging:service=ServerPeer");
            HashSet dests = (HashSet)this.beanServerConnection.getAttribute(objName, "Destinations");
            for (Destination dest : dests) {
                if (!(dest instanceof Queue)) continue;
                String qname = ((Queue)dest).getQueueName();
                log.trace((Object)qname);
                if (!qname.startsWith("BTR_.")) continue;
                String sname = qname.substring("BTR_.".length());
                sname = sname.replaceAll("[0-9]", "");
                log.trace((Object)("contains?: " + sname));
                if (!this.servers.contains(sname) || runningServerList.contains(sname)) continue;
                log.trace((Object)("contains!: " + sname));
                runningServerList.add(sname);
            }
        }
        catch (Exception e) {
            log.error((Object)("Caught an exception: " + e.getMessage()), (Throwable)e);
        }
        return runningServerList;
    }

    public List<Integer> listRunningInstanceIds(String serverName) {
        log.trace((Object)"listRunningInstanceIds");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        try {
            ObjectName objName = new ObjectName("jboss.messaging:service=ServerPeer");
            HashSet dests = (HashSet)this.beanServerConnection.getAttribute(objName, "Destinations");
            for (Destination dest : dests) {
                if (!(dest instanceof Queue)) continue;
                String qname = ((Queue)dest).getQueueName();
                log.trace((Object)qname);
                if (!qname.startsWith("BTR_.")) continue;
                String server = qname.substring("BTR_.".length());
                if (!(server = server.replaceAll("[0-9]", "")).equals(serverName)) continue;
                qname = qname.substring("BTR_.".length());
                qname = qname.replaceAll("[A-Za-z]", "");
                ids.add(new Integer(qname));
            }
        }
        catch (Exception e) {
            log.error((Object)("Caught an exception: " + e.getMessage()), (Throwable)e);
        }
        return ids;
    }

    public Element getServersStatus() {
        log.trace((Object)"getServersStatus");
        try {
            String status = "<servers>\n";
            for (String server : this.servers) {
                status = status + "\t<server>\n";
                status = status + "\t\t<name>" + server + "</name>\n";
                List<Integer> ids = this.listRunningInstanceIds(server);
                if (ids.size() > 0) {
                    status = status + "\t\t<instances>\n";
                    for (int i = 0; i < ids.size(); ++i) {
                        status = status + "\t\t\t<instance>\n";
                        status = status + "\t\t\t\t<id>" + ids.get(i) + "</id>\n";
                        status = status + "\t\t\t\t<status>1</status>\n";
                        status = status + "\t\t\t</instance>\n";
                    }
                    status = status + "\t\t</instances>\n";
                }
                status = status + "\t</server>\n";
            }
            status = status + "</servers>";
            return this.stringToElement(status);
        }
        catch (Exception e) {
            log.error((Object)("Caught an exception: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public Element listServiceStatus(String serverName, String serviceName) {
        log.trace((Object)"listServiceStatus");
        Element status = null;
        List<Integer> ids = this.listRunningInstanceIds(serverName);
        if (ids.size() == 0) {
            return null;
        }
        try {
            String servers = "<servers>";
            for (int i = 0; i < ids.size(); ++i) {
                Element result = this.listServiceStatusById(serverName, ids.get(i), serviceName);
                if (result == null) continue;
                servers = servers + "<instance><id>" + ids.get(i) + "</id>";
                servers = servers + this.elementToString(result);
                servers = servers + "</instance>";
            }
            servers = servers + "</servers>";
            status = this.stringToElement(servers);
        }
        catch (Exception e) {
            log.error((Object)("Caught an exception: " + e.getMessage()), (Throwable)e);
        }
        return status;
    }

    public Boolean advertise(String serverName, String serviceName) {
        log.trace((Object)"advertise");
        List<Integer> ids = this.listRunningInstanceIds(serverName);
        Boolean result = true;
        if (ids.size() == 0) {
            log.warn((Object)("Server was not running: " + serverName));
            return false;
        }
        for (int i = 0; i < ids.size(); ++i) {
            result = this.advertise(serverName, ids.get(i), serviceName) != false && result != false;
            log.warn((Object)("Failed to advertise service at: " + ids.get(i)));
        }
        return result;
    }

    public Boolean unadvertise(String serverName, String serviceName) {
        log.trace((Object)"unadvertise");
        List<Integer> ids = this.listRunningInstanceIds(serverName);
        Boolean result = true;
        if (ids.size() == 0) {
            log.warn((Object)("Server was not running: " + serverName));
            return false;
        }
        for (int i = 0; i < ids.size(); ++i) {
            result = this.unadvertise(serverName, ids.get(i), serviceName) != false && result != false;
            log.warn((Object)("Failed to unadvertise service at: " + ids.get(i)));
        }
        return result;
    }

    public Boolean shutdown(String serverName, int id) {
        log.trace((Object)"shutdown");
        if (this.servers.contains(serverName)) {
            String command = "serverdone";
            boolean shutdown = false;
            try {
                block11: {
                    if (id == 0) {
                        List<Integer> ids = this.listRunningInstanceIds(serverName);
                        for (int i = 0; i < ids.size(); ++i) {
                            this.callAdminService(serverName, ids.get(i), command);
                        }
                    } else {
                        this.callAdminService(serverName, id, command);
                    }
                    int timeout = 40;
                    do {
                        List<Integer> ids = this.listRunningInstanceIds(serverName);
                        if (!(id == 0 && ids.size() > 0 || ids.contains(id))) {
                            shutdown = true;
                            break block11;
                        }
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } while (--timeout != 0);
                    log.warn((Object)("Server did not shutdown in time: " + serverName + ": " + id));
                }
                return shutdown;
            }
            catch (ConnectionException e) {
                log.error((Object)("call server " + serverName + " id " + id + " failed with " + e.getTperrno()), (Throwable)e);
                return false;
            }
            catch (RuntimeException e) {
                log.error((Object)("Could not shutdown server: " + e.getMessage()), (Throwable)e);
                throw e;
            }
        }
        log.error((Object)("Server not configured: " + serverName));
        return false;
    }

    public String getResponseTimeById(String serverName, int id, String serviceName) {
        log.trace((Object)"getResponseTimeById");
        String command = "responsetime," + serviceName + ",";
        log.trace((Object)("response command is " + command));
        try {
            Response buf = this.callAdminService(serverName, id, command);
            if (buf != null) {
                byte[] received = ((X_OCTET)buf.getBuffer()).getByteArray();
                String result = new String(received, 1, received.length - 1);
                log.trace((Object)("response result is " + result));
                return result;
            }
        }
        catch (ConnectionException e) {
            log.error((Object)("call server " + serverName + " id " + id + " failed with " + e.getTperrno()), (Throwable)e);
        }
        catch (RuntimeException e) {
            log.error((Object)("Could not get response time from server: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        return null;
    }

    public String getResponseTime(String serverName, String serviceName) {
        log.trace((Object)"getResponseTime");
        List<Integer> ids = this.listRunningInstanceIds(serverName);
        long min = 0L;
        long avg = 0L;
        long max = 0L;
        long total = 0L;
        for (int i = 0; i < ids.size(); ++i) {
            String responseTime = this.getResponseTimeById(serverName, ids.get(i), serviceName);
            String[] times = responseTime.split(",");
            if (times.length != 3) continue;
            long t = Long.valueOf(times[0]);
            if (min == 0L || t < min) {
                min = t;
            }
            if ((t = Long.valueOf(times[2]).longValue()) > max) {
                max = t;
            }
            long counter = this.getServiceCounterById(serverName, ids.get(i), serviceName);
            t = Long.valueOf(times[1]);
            if (total == 0L && counter == 0L) continue;
            avg = (avg * total + t * counter) / (total + counter);
        }
        return String.format("%d,%d,%d", min, avg, max);
    }

    public long getServiceCounterById(String serverName, int id, String serviceName) {
        log.trace((Object)"getServiceCounterById");
        long counter = 0L;
        String command = "counter," + serviceName + ",";
        try {
            Response buf = this.callAdminService(serverName, id, command);
            if (buf != null) {
                byte[] received = ((X_OCTET)buf.getBuffer()).getByteArray();
                counter = Long.parseLong(new String(received, 1, received.length - 1));
            }
        }
        catch (ConnectionException e) {
            log.error((Object)("call server " + serverName + " id " + id + " failed with " + e.getTperrno()));
        }
        return counter;
    }

    public long getServiceCounter(String serverName, String serviceName) {
        log.trace((Object)"getServiceCounter");
        long counter = 0L;
        List<Integer> ids = this.listRunningInstanceIds(serverName);
        for (int i = 0; i < ids.size(); ++i) {
            counter += this.getServiceCounterById(serverName, ids.get(i), serviceName);
        }
        return counter;
    }

    public long getErrorCounterById(String serverName, int id, String serviceName) {
        log.trace((Object)"getErrorCounterById");
        long counter = 0L;
        String command = "error_counter," + serviceName + ",";
        try {
            Response buf = this.callAdminService(serverName, id, command);
            if (buf != null) {
                byte[] received = ((X_OCTET)buf.getBuffer()).getByteArray();
                counter = Long.parseLong(new String(received, 1, received.length - 1));
            }
        }
        catch (ConnectionException e) {
            log.error((Object)("call server " + serverName + " id " + id + " failed with " + e.getTperrno()));
        }
        return counter;
    }

    public long getErrorCounter(String serverName, String serviceName) {
        log.trace((Object)"getErrorCounter");
        long counter = 0L;
        List<Integer> ids = this.listRunningInstanceIds(serverName);
        for (int i = 0; i < ids.size(); ++i) {
            counter += this.getErrorCounterById(serverName, ids.get(i), serviceName);
        }
        return counter;
    }

    public Boolean reloadDomain() {
        log.trace((Object)"reloadDomain");
        Boolean result = true;
        List<String> servers = this.listRunningServers();
        for (int i = 0; i < servers.size(); ++i) {
            result = this.reloadServer(servers.get(i)) != false && result != false;
        }
        return result;
    }

    public Boolean reloadServer(String serverName) {
        log.trace((Object)"reloadServer");
        Boolean result = true;
        List<Integer> ids = this.listRunningInstanceIds(serverName);
        for (int i = 0; i < ids.size(); ++i) {
            result = this.reloadServerById(serverName, ids.get(i)) != false && result != false;
        }
        return result;
    }

    public Boolean reloadServerById(String serverName, int id) {
        log.trace((Object)"reloadServerById");
        return false;
    }

    public Element listServiceStatusById(String serverName, int id, String serviceName) {
        log.trace((Object)"listServiceStatusById");
        String command = "status";
        Response buf = null;
        String status = null;
        try {
            byte[] received;
            if (serviceName != null) {
                command = command + "," + serviceName + ",";
            }
            if ((buf = this.callAdminService(serverName, id, command)) != null && (received = ((X_OCTET)buf.getBuffer()).getByteArray())[0] == 49) {
                status = new String(received, 1, received.length - 1);
                log.info((Object)("status is " + status));
                return this.stringToElement(status);
            }
        }
        catch (ConnectionException e) {
            log.error((Object)("call server " + serverName + " id " + id + " failed with " + e.getTperrno()));
        }
        catch (Exception e) {
            log.error((Object)("response " + status + " error with " + e));
        }
        return null;
    }

    public MBeanServerConnection getBeanServerConnection() {
        log.trace((Object)"getBeanServerConnection");
        return this.beanServerConnection;
    }

    public void close() throws ConnectionException, IOException {
        log.debug((Object)"Closed Administration Proxy");
        this.connection.close();
        this.c.close();
    }

    public int getQueueDepth(String serverName, String serviceName) {
        Integer depth;
        try {
            log.trace((Object)serviceName);
            boolean conversational = false;
            if (!serviceName.startsWith(".")) {
                conversational = (Boolean)this.prop.get("blacktie." + serviceName + ".conversational");
            }
            String prefix = null;
            prefix = conversational ? "BTC_" : "BTR_";
            ObjectName objName = new ObjectName("jboss.messaging.destination:service=Queue,name=" + prefix + serviceName);
            depth = (Integer)this.beanServerConnection.getAttribute(objName, "MessageCount");
        }
        catch (Exception e) {
            log.error((Object)("getQueueDepth failed with " + e));
            return -1;
        }
        return depth;
    }

    public String getServerName(String serviceName) {
        return this.prop.getProperty("blacktie." + serviceName + ".server");
    }

    public String getServerVersionById(String serverName, int id) {
        log.trace((Object)"getServerVersionById");
        String command = "version";
        Response buf = null;
        String version = null;
        try {
            byte[] received;
            buf = this.callAdminService(serverName, id, command);
            if (buf != null && (received = ((X_OCTET)buf.getBuffer()).getByteArray())[0] == 49) {
                version = new String(received, 1, received.length - 1);
                log.debug((Object)("version is " + version));
            }
        }
        catch (ConnectionException e) {
            log.error((Object)("call server " + serverName + " id " + id + " failed with " + e.getTperrno()), (Throwable)e);
        }
        return version;
    }
}

