/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.blacktie.administration;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.blacktie.administration.BlacktieAdministration;
import org.jboss.blacktie.administration.core.AdministrationProxy;
import org.jboss.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.blacktie.jatmibroker.xatmi.Buffer;
import org.jboss.blacktie.jatmibroker.xatmi.ConnectionException;
import org.jboss.blacktie.jatmibroker.xatmi.Response;
import org.jboss.blacktie.jatmibroker.xatmi.TPSVCINFO;
import org.jboss.blacktie.jatmibroker.xatmi.X_OCTET;
import org.jboss.blacktie.jatmibroker.xatmi.mdb.MDBBlacktieService;
import org.jboss.ejb3.annotation.Depends;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/BTR_BTDomainAdmin")}, messageListenerInterface=MessageListener.class)
@Depends(value={"jboss.messaging.destination:service=Queue,name=BTR_BTDomainAdmin"})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class BlacktieAdminServiceXATMI
extends MDBBlacktieService
implements MessageListener,
BlacktieAdministration {
    private static final Logger log = LogManager.getLogger(BlacktieAdminServiceXATMI.class);
    private AdministrationProxy administrationProxy = new AdministrationProxy();

    public Response tpservice(TPSVCINFO svcinfo) {
        log.trace((Object)"Message received");
        X_OCTET recv = (X_OCTET)svcinfo.getBuffer();
        String string = new String(recv.getByteArray());
        StringTokenizer parameters = new StringTokenizer(string, ",", false);
        String operation = parameters.nextToken();
        byte[] toReturn = null;
        try {
            if (operation.equals("getDomainName")) {
                String response = this.getDomainName();
                toReturn = response.getBytes();
            } else if (operation.equals("getServerName")) {
                String serviceName = this.getString(parameters);
                String response = this.getServerName(serviceName);
                toReturn = response.getBytes();
            } else if (operation.equals("getSoftwareVersion")) {
                String response = this.getSoftwareVersion();
                toReturn = response.getBytes();
            } else if (operation.equals("pauseDomain")) {
                boolean response = this.pauseDomain();
                toReturn = this.convertBoolean(response);
            } else if (operation.equals("resumeDomain")) {
                boolean response = this.resumeDomain();
                toReturn = this.convertBoolean(response);
            } else if (operation.equals("getServerList")) {
                List<String> response = this.getServerList();
                toReturn = this.convertListString(response);
            } else if (operation.equals("listRunningServers")) {
                List<String> response = this.listRunningServers();
                toReturn = this.convertListString(response);
            } else if (operation.equals("listRunningInstanceIds")) {
                String serverName = this.getString(parameters);
                List<Integer> response = this.listRunningInstanceIds(serverName);
                toReturn = this.convertListInt(response);
            } else if (operation.equals("getServersStatus")) {
                Element response = this.getServersStatus();
                toReturn = response.toString().getBytes();
            } else if (operation.equals("listServiceStatus")) {
                String serverName = this.getString(parameters);
                String serviceName = this.getString(parameters);
                Element response = this.listServiceStatus(serverName, serviceName);
                toReturn = response.toString().getBytes();
            } else if (operation.equals("advertise")) {
                String serverName = this.getString(parameters);
                String serviceName = this.getString(parameters);
                boolean response = this.advertise(serverName, serviceName);
                toReturn = this.convertBoolean(response);
            } else if (operation.equals("unadvertise")) {
                String serverName = this.getString(parameters);
                String serviceName = this.getString(parameters);
                boolean response = this.unadvertise(serverName, serviceName);
                toReturn = this.convertBoolean(response);
            } else if (operation.equals("shutdown")) {
                String serverName = this.getString(parameters);
                int id = this.getInt(parameters);
                this.shutdown(serverName, id);
                toReturn = new byte[]{1};
            } else if (operation.equals("getServiceCounterById")) {
                String serverName = this.getString(parameters);
                int id = this.getInt(parameters);
                String serviceName = this.getString(parameters);
                long response = this.getServiceCounterById(serverName, id, serviceName);
                toReturn = this.convertLong(response);
            } else if (operation.equals("getServiceCounter")) {
                String serverName = this.getString(parameters);
                String serviceName = this.getString(parameters);
                long response = this.getServiceCounter(serverName, serviceName);
                toReturn = this.convertLong(response);
            } else if (operation.equals("getErrorCounter")) {
                String serverName = this.getString(parameters);
                String serviceName = this.getString(parameters);
                long response = this.getErrorCounter(serverName, serviceName);
                toReturn = this.convertLong(response);
            } else if (operation.equals("reloadDomain")) {
                boolean response = this.reloadDomain();
                toReturn = this.convertBoolean(response);
            } else if (operation.equals("reloadServer")) {
                String serverName = this.getString(parameters);
                boolean response = this.reloadServer(serverName);
                toReturn = this.convertBoolean(response);
            } else if (operation.equals("listServiceStatusById")) {
                String serverName = this.getString(parameters);
                int id = this.getInt(parameters);
                String serviceName = this.getString(parameters);
                Element response = this.listServiceStatusById(serverName, id, serviceName);
                toReturn = response.toString().getBytes();
            } else if (operation.equals("getDomainStatus")) {
                boolean response = this.getDomainStatus();
                toReturn = this.convertBoolean(response);
            } else if (operation.equals("getResponseTime")) {
                String serverName = this.getString(parameters);
                String serviceName = this.getString(parameters);
                String times = this.getResponseTime(serverName, serviceName);
                toReturn = times.getBytes();
            } else if (operation.equals("getQueueDepth")) {
                String serverName = this.getString(parameters);
                String serviceName = this.getString(parameters);
                int depth = this.getQueueDepth(serverName, serviceName);
                toReturn = new StringBuffer().append(depth).toString().getBytes();
            } else if (operation.equals("getServerVersionById")) {
                String serverName = this.getString(parameters);
                int id = this.getInt(parameters);
                String response = this.getServerVersionById(serverName, id);
                toReturn = response.getBytes();
            }
            X_OCTET buffer = (X_OCTET)svcinfo.getConnection().tpalloc("X_OCTET", null, toReturn.length);
            buffer.setByteArray(toReturn);
            log.debug((Object)"Responding");
            return new Response(2, 0, (Buffer)buffer, 0);
        }
        catch (ConnectionException e) {
            return new Response(1, 0, null, 0);
        }
        catch (IOException e) {
            return new Response(1, 0, null, 0);
        }
    }

    private byte[] convertListInt(List<Integer> response) {
        StringBuffer toReturn = new StringBuffer();
        Iterator<Integer> iterator = response.iterator();
        while (iterator.hasNext()) {
            toReturn.append(iterator.next());
            toReturn.append(',');
        }
        return toReturn.toString().getBytes();
    }

    private byte[] convertLong(long response) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        ByteBuffer bbuf = ByteBuffer.allocate(8);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        bbuf.putLong(response);
        bbuf.order(ByteOrder.LITTLE_ENDIAN);
        long toWrite = bbuf.getLong(0);
        dos.writeLong(toWrite);
        dos.flush();
        baos.flush();
        return baos.toByteArray();
    }

    private byte[] convertListString(List<String> response) {
        StringBuffer toReturn = new StringBuffer();
        Iterator<String> iterator = response.iterator();
        while (iterator.hasNext()) {
            toReturn.append(iterator.next());
            toReturn.append(',');
        }
        toReturn.append("|");
        return toReturn.toString().getBytes();
    }

    private byte[] convertBoolean(boolean response) {
        byte[] toReturn = new byte[1];
        if (response) {
            toReturn[0] = 1;
        }
        return toReturn;
    }

    private String getString(StringTokenizer parameters) {
        return parameters.nextToken();
    }

    private int getInt(StringTokenizer parameters) {
        return Integer.parseInt(parameters.nextToken());
    }

    @Override
    public String getDomainName() {
        return this.administrationProxy.getDomainName();
    }

    @Override
    public String getSoftwareVersion() {
        return this.administrationProxy.getSoftwareVersion();
    }

    @Override
    public Boolean getDomainStatus() {
        return this.administrationProxy.getDomainStatus();
    }

    @Override
    public Boolean pauseDomain() {
        return this.administrationProxy.pauseDomain();
    }

    @Override
    public Boolean resumeDomain() {
        return this.administrationProxy.resumeDomain();
    }

    @Override
    public List<String> getServerList() {
        return this.administrationProxy.getServerList();
    }

    @Override
    public List<String> listRunningServers() {
        return this.administrationProxy.listRunningServers();
    }

    @Override
    public List<Integer> listRunningInstanceIds(String serverName) {
        return this.administrationProxy.listRunningInstanceIds(serverName);
    }

    @Override
    public Element getServersStatus() {
        return this.administrationProxy.getServersStatus();
    }

    @Override
    public Element listServiceStatus(String serverName, String serviceName) {
        return this.administrationProxy.listServiceStatus(serverName, serviceName);
    }

    @Override
    public Boolean advertise(String serverName, String serviceName) {
        return this.administrationProxy.advertise(serverName, serviceName);
    }

    @Override
    public Boolean unadvertise(String serverName, String serviceName) {
        return this.administrationProxy.unadvertise(serverName, serviceName);
    }

    @Override
    public Boolean shutdown(String serverName, int id) {
        return this.administrationProxy.shutdown(serverName, id);
    }

    @Override
    public long getServiceCounterById(String serverName, int id, String serviceName) {
        return this.administrationProxy.getServiceCounterById(serverName, id, serviceName);
    }

    @Override
    public long getServiceCounter(String serverName, String serviceName) {
        return this.administrationProxy.getServiceCounter(serverName, serviceName);
    }

    @Override
    public Boolean reloadDomain() {
        return this.administrationProxy.reloadDomain();
    }

    @Override
    public Boolean reloadServer(String serverName) {
        return this.administrationProxy.reloadServer(serverName);
    }

    @Override
    public Element listServiceStatusById(String serverName, int id, String serviceName) {
        return this.administrationProxy.listServiceStatusById(serverName, id, serviceName);
    }

    public void start() throws Exception {
        throw new RuntimeException("This operation is not applicable to the XATMI admin service");
    }

    public void stop() throws Exception {
        throw new RuntimeException("This operation is not applicable to the XATMI admin service");
    }

    @Override
    public String getResponseTime(String serverName, String serviceName) {
        return this.administrationProxy.getResponseTime(serverName, serviceName);
    }

    @Override
    public String getResponseTimeById(String serverName, int id, String serviceName) {
        return this.administrationProxy.getResponseTimeById(serverName, id, serviceName);
    }

    @Override
    public int getQueueDepth(String serverName, String serviceName) {
        return this.administrationProxy.getQueueDepth(serverName, serviceName);
    }

    @Override
    public String getServerName(String serviceName) {
        return this.administrationProxy.getServerName(serviceName);
    }

    @Override
    public long getErrorCounter(String serverName, String serviceName) {
        return this.administrationProxy.getErrorCounter(serverName, serviceName);
    }

    @Override
    public long getErrorCounterById(String serverName, int id, String serviceName) {
        return this.administrationProxy.getErrorCounterById(serverName, id, serviceName);
    }

    @Override
    public String getServerVersionById(String serverName, int id) {
        return this.administrationProxy.getServerVersionById(serverName, id);
    }
}

