/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.blacktie.administration;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.blacktie.administration.BlacktieStompAdministrationService;
import org.jboss.blacktie.administration.core.AdministrationProxy;
import org.jboss.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.blacktie.jatmibroker.core.conf.XMLParser;

public class QueueReaper
implements Runnable {
    private static final Logger log = LogManager.getLogger(QueueReaper.class);
    private long interval = -1L;
    private Thread thread = new Thread(this);
    private boolean run;
    private Properties prop;
    private AdministrationProxy administrationProxy;

    public QueueReaper(AdministrationProxy administrationProxy) throws ConfigurationException {
        this.thread.setDaemon(true);
        this.thread.setPriority(1);
        this.administrationProxy = administrationProxy;
        this.prop = new Properties();
        XMLParser.loadProperties((String)"btconfig.xsd", (String)"btconfig.xml", (Properties)this.prop);
        this.interval = Integer.parseInt(this.prop.getProperty("QueueReaperInterval", "30")) * 1000;
    }

    public void startThread() {
        if (!this.run) {
            this.run = true;
            if (this.thread.isInterrupted()) {
                Thread.interrupted();
            }
            this.thread.start();
        } else {
            log.debug((Object)"Thread already running");
        }
    }

    public void stopThread() {
        if (!this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
        this.run = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            log.warn((Object)("Could not join with reaper: " + e.getMessage()));
        }
    }

    public boolean isRunning() {
        return this.run;
    }

    public void run() {
        while (this.run) {
            try {
                ObjectName objName = new ObjectName("org.hornetq:module=JMS,type=Server");
                String[] dests = (String[])this.administrationProxy.getBeanServerConnection().getAttribute(objName, "QueueNames");
                for (int i = 0; i < dests.length; ++i) {
                    String serviceName = dests[i];
                    serviceName = serviceName.substring(serviceName.indexOf(95) + 1);
                    String server = (String)this.prop.get("blacktie." + serviceName + ".server");
                    log.trace((Object)("Checking for: " + serviceName + " " + this.prop.get("blacktie." + serviceName + ".externally-managed-destination")));
                    if ((server != null && !((Boolean)this.prop.get("blacktie." + serviceName + ".externally-managed-destination")).booleanValue() || serviceName.contains(".")) && this.consumerCount(serviceName) == 0) {
                        log.warn((Object)("undeploy service pending for " + serviceName + " as consumer count is 0, will check again in 30 seconds"));
                        long queueReapCheck = System.currentTimeMillis();
                        Thread.sleep(this.interval);
                        if (this.isOlderThanReapCheck(serviceName, queueReapCheck) && this.consumerCount(serviceName) == 0) {
                            this.undeployQueue(serviceName);
                            log.warn((Object)("undeploy service " + serviceName + " for consumer is 0"));
                            continue;
                        }
                        log.info((Object)("Undeploy not required for: " + serviceName + " at: " + server));
                        continue;
                    }
                    log.debug((Object)("Undeploy not required for: " + serviceName + " at: " + server));
                }
                log.debug((Object)("Sleeping for " + this.interval + " ms"));
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                log.debug((Object)"Sleeping interrupted");
                this.run = false;
            }
            catch (Exception e) {
                log.error((Object)("run ping thread failed with (will wait for: " + this.interval + " seconds): " + e), (Throwable)e);
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e2) {
                    log.debug((Object)"Sleeping interrupted");
                    this.run = false;
                }
            }
        }
    }

    int consumerCount(String serviceName) throws MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException, MBeanException {
        log.trace((Object)serviceName);
        boolean conversational = false;
        if (!serviceName.startsWith(".")) {
            conversational = (Boolean)this.prop.get("blacktie." + serviceName + ".conversational");
        }
        String prefix = null;
        prefix = conversational ? "BTC_" : "BTR_";
        ObjectName objName = new ObjectName("org.hornetq:module=JMS,name=\"" + prefix + serviceName + "\",type=Queue");
        try {
            Integer count = (Integer)this.administrationProxy.getBeanServerConnection().getAttribute(objName, "ConsumerCount");
            return count;
        }
        catch (InstanceNotFoundException e) {
            log.debug((Object)("Instance not found: " + objName));
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOlderThanReapCheck(String serviceName, long queueReapCheck) {
        Hashtable<String, Long> hashtable = BlacktieStompAdministrationService.QUEUE_CREATION_TIMES;
        synchronized (hashtable) {
            boolean toReturn = false;
            Long creationTime = BlacktieStompAdministrationService.QUEUE_CREATION_TIMES.get(serviceName);
            if (creationTime != null) {
                boolean bl = toReturn = creationTime < queueReapCheck;
                if (!toReturn) {
                    log.warn((Object)("New queue will be ignored: " + serviceName));
                }
            }
            return toReturn;
        }
    }

    int undeployQueue(String serviceName) {
        int result = 0;
        try {
            log.trace((Object)serviceName);
            boolean conversational = false;
            if (!serviceName.startsWith(".")) {
                conversational = (Boolean)this.prop.get("blacktie." + serviceName + ".conversational");
            }
            String prefix = null;
            prefix = conversational ? "BTC_" : "BTR_";
            ObjectName objName = new ObjectName("org.hornetq:module=JMS,type=Server");
            this.administrationProxy.getBeanServerConnection().invoke(objName, "destroyQueue", new Object[]{prefix + serviceName}, new String[]{"java.lang.String"});
            result = 1;
        }
        catch (Throwable t) {
            log.error((Object)("Could not undeploy queue of " + serviceName), t);
        }
        return result;
    }
}

