/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.blacktie.btadmin;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.blacktie.btadmin.Command;
import org.jboss.blacktie.btadmin.CommandFailedException;
import org.jboss.blacktie.btadmin.IncompatibleArgsException;
import org.jboss.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.blacktie.jatmibroker.core.conf.XMLEnvHandler;
import org.jboss.blacktie.jatmibroker.core.conf.XMLParser;
import org.xml.sax.helpers.DefaultHandler;

public class CommandHandler {
    private static Logger log = LogManager.getLogger(CommandHandler.class);
    private MBeanServerConnection beanServerConnection;
    private ObjectName blacktieAdmin;
    private Properties prop = new Properties();
    private String url;

    public CommandHandler() throws ConfigurationException, MalformedObjectNameException, NullPointerException {
        XMLEnvHandler handler = new XMLEnvHandler(this.prop);
        XMLParser xmlenv = new XMLParser((DefaultHandler)handler, "btconfig.xsd");
        xmlenv.parse("btconfig.xml");
        this.url = (String)this.prop.get("JMXURL");
        if (this.url == null) {
            throw new ConfigurationException("No JMX url configuration in btconfig.xml");
        }
        this.blacktieAdmin = new ObjectName("jboss.blacktie:service=Admin");
    }

    public int handleCommand(String[] args) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NullPointerException, IOException {
        int exitStatus = -1;
        if (args.length < 1 || args[0] == null || args[0].trim().length() == 0) {
            log.error((Object)"No command was provided");
        } else {
            Command command = CommandHandler.loadCommand(args[0]);
            String[] commandArgs = new String[args.length - 1];
            if (commandArgs.length > 0) {
                log.trace((Object)"Copying arguments for the command");
                System.arraycopy(args, 1, commandArgs, 0, commandArgs.length);
            }
            String exampleUsage = command.getExampleUsage();
            char[] charArray = exampleUsage.toCharArray();
            int expectedArgsLength = 0;
            int optionalArgs = 0;
            for (int i = 0; i < exampleUsage.length(); ++i) {
                if (charArray[i] == ' ') {
                    ++expectedArgsLength;
                    continue;
                }
                if (charArray[i] != '[') continue;
                ++optionalArgs;
            }
            if (charArray.length > 0) {
                ++expectedArgsLength;
            }
            if (commandArgs.length > expectedArgsLength || commandArgs.length < expectedArgsLength - optionalArgs) {
                if (optionalArgs == 0) {
                    log.trace((Object)("Arguments incompatible, expected " + expectedArgsLength + ", received: " + commandArgs.length));
                } else {
                    log.trace((Object)("Arguments incompatible, expected at least " + optionalArgs + " and no more than " + expectedArgsLength + ", received: " + commandArgs.length));
                }
                log.error((Object)("Expected Usage: " + args[0] + " " + exampleUsage).trim());
            } else {
                if (command.requiresAdminConnection()) {
                    this.initializeAdminConnection();
                }
                try {
                    command.initializeArgs(commandArgs);
                    log.trace((Object)"Arguments initialized");
                    try {
                        command.invoke(this.beanServerConnection, this.blacktieAdmin, this.prop);
                        exitStatus = 0;
                        log.trace((Object)"Command invoked");
                    }
                    catch (CommandFailedException e) {
                        exitStatus = e.getExitCode();
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not invoke the command: " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (IncompatibleArgsException e) {
                    String usage = "Expected Usage: " + args[0] + " " + exampleUsage;
                    log.error((Object)("Arguments invalid: " + e.getMessage()));
                    log.error((Object)usage.trim());
                    log.trace((Object)("Arguments invalid: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return exitStatus;
    }

    public static Command loadCommand(String commandName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String firstLetter = commandName.substring(0, 1);
        String remainder = commandName.substring(1);
        String capitalized = firstLetter.toUpperCase() + remainder;
        String className = "org.jboss.blacktie.btadmin.commands." + capitalized;
        log.trace((Object)("Will execute the " + className + " command"));
        Command command = (Command)Class.forName(className).newInstance();
        log.debug((Object)"Command was known");
        return command;
    }

    public void initializeAdminConnection() throws IOException {
        if (this.beanServerConnection == null) {
            JMXServiceURL u = new JMXServiceURL(this.url);
            JMXConnector c = JMXConnectorFactory.connect(u);
            this.beanServerConnection = c.getMBeanServerConnection();
        }
    }

    public static String convertList(String operationName, List list) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Output from: " + operationName);
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            buffer.append("\nElement: " + i + " Value: " + iterator.next());
            ++i;
        }
        return buffer.toString();
    }
}

