/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.blacktie.btadmin.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.blacktie.btadmin.Command;
import org.jboss.blacktie.btadmin.CommandFailedException;
import org.jboss.blacktie.btadmin.IncompatibleArgsException;
import org.jboss.blacktie.jatmibroker.core.conf.Machine;
import org.jboss.blacktie.jatmibroker.core.conf.Server;

public class Shutdown
implements Command {
    private static Logger log = LogManager.getLogger(Shutdown.class);
    private String serverName;
    private int id = 0;

    public boolean requiresAdminConnection() {
        return true;
    }

    public String getExampleUsage() {
        return "[<serverName> [<serverId>]]";
    }

    public void initializeArgs(String[] args) throws IncompatibleArgsException {
        if (args.length > 0) {
            this.serverName = args[0];
            if (args.length == 2) {
                try {
                    this.id = Integer.parseInt(args[1]);
                    log.trace((Object)("Successfully parsed: " + args[1]));
                }
                catch (NumberFormatException nfe) {
                    throw new IncompatibleArgsException("The third argument was expected to be the (integer) instance id to shutdown");
                }
            }
        }
    }

    public void invoke(MBeanServerConnection beanServerConnection, ObjectName blacktieAdmin, Properties configuration) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, CommandFailedException {
        ArrayList<ServerToStop> serversToStop = new ArrayList<ServerToStop>();
        List serverLaunchers = (List)configuration.get("blacktie.domain.serverLaunchers");
        if (this.serverName == null) {
            for (Server server : serverLaunchers) {
                for (Machine machine : server.getLocalMachine()) {
                    ServerToStop serverToStop = new ServerToStop();
                    serverToStop.setName(server.getName());
                    serverToStop.setId(machine.getServerId());
                    serversToStop.add(serverToStop);
                }
            }
        } else {
            ServerToStop serverToStop = new ServerToStop();
            serverToStop.setName(this.serverName);
            serverToStop.setId(this.id);
            serversToStop.add(serverToStop);
        }
        if (serversToStop.size() != 0) {
            for (ServerToStop next : serversToStop) {
                Boolean result = (Boolean)beanServerConnection.invoke(blacktieAdmin, "shutdown", new Object[]{next.getName(), next.getId()}, new String[]{"java.lang.String", "int"});
                if (result.booleanValue()) {
                    log.info((Object)("Server shutdown successfully: " + next.getName() + " with id: " + next.getId()));
                    continue;
                }
                log.error((Object)"Server could not be shutdown (may already be stopped)");
                throw new CommandFailedException(-1);
            }
        } else {
            log.error((Object)"No servers were configured for shutdown");
            throw new CommandFailedException(-1);
        }
    }

    private class ServerToStop {
        private String name;
        private int id;

        private ServerToStop() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

