/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.blacktie.btadmin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import javax.management.MalformedObjectNameException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.blacktie.btadmin.CommandHandler;
import org.jboss.blacktie.jatmibroker.core.conf.ConfigurationException;

public class BTAdmin {
    private static Logger log = LogManager.getLogger(BTAdmin.class);
    private static InputStreamReader isr = new InputStreamReader(System.in);
    private static BufferedReader br = new BufferedReader(isr);

    public static void main(String[] args) throws IOException {
        int exitStatus = -1;
        if (System.getProperty("log4j.configuration") == null && !new File("log4cxx.properties").exists() && !new File("log4j.xml").exists()) {
            BasicConfigurator.configure();
            log.info((Object)"BasicConfigurator ran");
        }
        boolean interactive = args.length == 0;
        boolean done = false;
        try {
            CommandHandler commandHandler = new CommandHandler();
            do {
                if (interactive) {
                    System.out.print("> ");
                    args = br.readLine().split("\\s+");
                }
                try {
                    exitStatus = commandHandler.handleCommand(args);
                    if (exitStatus == 0) {
                        log.trace((Object)"Command was successful");
                    } else {
                        log.trace((Object)"Command failed");
                    }
                    if (args.length <= 0 || !args[0].equals("quit")) continue;
                    done = true;
                }
                catch (MalformedURLException e) {
                    log.error((Object)("JMXURL was incorrect: " + e.getMessage()), (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)("No connect to mbean server: " + e.getMessage()), (Throwable)e);
                }
                catch (NullPointerException e) {
                    log.error((Object)("MBean name raised an NPE: " + e.getMessage()), (Throwable)e);
                }
                catch (InstantiationException e) {
                    log.error((Object)("Command could not be loaded: " + e.getMessage()), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Command could not be loaded: " + e.getMessage()), (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Command could not be loaded: " + e.getMessage()), (Throwable)e);
                }
            } while (interactive && !done);
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)("MBean name was badly structured: " + e.getMessage()), (Throwable)e);
        }
        catch (ConfigurationException e) {
            log.error((Object)("BlackTie Configuration invalid: " + e.getMessage()), (Throwable)e);
        }
        if (!interactive) {
            Runtime.getRuntime().halt(exitStatus);
        }
    }
}

