/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.blacktie.btadmin.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.blacktie.btadmin.Command;
import org.jboss.blacktie.btadmin.CommandFailedException;
import org.jboss.blacktie.btadmin.IncompatibleArgsException;
import org.jboss.blacktie.jatmibroker.core.conf.Machine;
import org.jboss.blacktie.jatmibroker.core.conf.Server;

public class Startup
implements Command {
    private static Logger log = LogManager.getLogger(Startup.class);
    private String serverName;

    public boolean requiresAdminConnection() {
        return false;
    }

    public String getExampleUsage() {
        return "[<serverName>]";
    }

    public void initializeArgs(String[] args) throws IncompatibleArgsException {
        if (args.length == 1) {
            this.serverName = args[0];
        }
    }

    public void invoke(MBeanServerConnection beanServerConnection, ObjectName blacktieAdmin, Properties configuration) throws CommandFailedException, IOException {
        List serverLaunchers = (List)configuration.get("blacktie.domain.serverLaunchers");
        boolean found = false;
        for (Server next : serverLaunchers) {
            List localMachinesList;
            if (this.serverName != null && !this.serverName.equals(next.getName())) continue;
            if (this.serverName != null) {
                log.debug((Object)("Listing machines for: " + this.serverName));
            } else {
                log.debug((Object)"Listing machines");
            }
            if ((localMachinesList = next.getLocalMachine()).size() == 0) continue;
            Iterator localMachines = localMachinesList.iterator();
            while (localMachines.hasNext()) {
                String readLine;
                log.debug((Object)"Found machine");
                Machine localMachine = (Machine)localMachines.next();
                String pathToExecutable = localMachine.getPathToExecutable();
                String argLine = "-i " + localMachine.getServerId();
                if (localMachine.getArgLine() != null) {
                    argLine = argLine + " " + localMachine.getArgLine();
                }
                String[] split = argLine.split(" ");
                String[] cmdarray = new String[split.length + 1 + 0];
                cmdarray[0] = pathToExecutable;
                System.arraycopy(split, 0, cmdarray, 1, split.length);
                String[] envp = null;
                File dir = new File(localMachine.getWorkingDirectory());
                Process exec = Runtime.getRuntime().exec(cmdarray, envp, dir);
                log.debug((Object)("Launched server: " + pathToExecutable));
                BufferedReader output = new BufferedReader(new InputStreamReader(exec.getInputStream()));
                BufferedReader error = new BufferedReader(new InputStreamReader(exec.getErrorStream()));
                do {
                    if ((readLine = output.readLine()) == null) {
                        readLine = error.readLine();
                    }
                    log.info((Object)readLine);
                    if (readLine == null) {
                        throw new CommandFailedException(-3);
                    }
                    if (!readLine.endsWith("serverinit failed")) continue;
                    throw new CommandFailedException(-2);
                } while (!readLine.endsWith("Server waiting for requests..."));
                new Thread(new EatIO(exec.getInputStream())).start();
                new Thread(new EatIO(exec.getErrorStream())).start();
                found = true;
            }
        }
        if (!found) {
            log.error((Object)"No machines configured for host");
            throw new CommandFailedException(-1);
        }
    }

    private class EatIO
    implements Runnable {
        private InputStream is;

        public EatIO(InputStream is) {
            this.is = is;
        }

        public void run() {
            byte[] buf = new byte[1024];
            try {
                int len;
                while ((len = this.is.read(buf)) > 0) {
                }
            }
            catch (IOException e) {
                log.error((Object)"Could not write output");
            }
        }
    }
}

