/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.bootstrap.impl.as.lifecycle;

import org.jboss.bootstrap.spi.server.ServerProvider;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;

/**
 * KernelStartEventLifecycleEventHandler
 * 
 * Fires the Kernel event for start in the Server lifecycle
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 */
public class KernelStartEventLifecycleEventHandler extends AbstractKernelEventLifecycleEventHandler
{

   //-------------------------------------------------------------------------------------||
   // Constructor ------------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   public KernelStartEventLifecycleEventHandler(final BasicBootstrap bootstrap)
   {
      super(bootstrap);
   }

   //-------------------------------------------------------------------------------------||
   // Required Implementations -----------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /* (non-Javadoc)
    * @see org.jboss.bootstrap.impl.as.lifecycle.AbstractKernelEventLifecycleEventHandler#getNotificationType()
    */
   @Override
   protected String getNotificationType()
   {
      return ServerProvider.START_NOTIFICATION_TYPE;
   }

}
