/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.as.lifecycle;

import org.jboss.bootstrap.api.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.api.lifecycle.LifecycleEventHandler;
import org.jboss.bootstrap.api.lifecycle.LifecycleState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.event.AbstractEvent;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventManager;
import org.jboss.logging.Logger;

public abstract class AbstractKernelEventLifecycleEventHandler
implements LifecycleEventHandler {
    private static final Logger log = Logger.getLogger(AbstractKernelEventLifecycleEventHandler.class);
    private BasicBootstrap bootstrap;

    public AbstractKernelEventLifecycleEventHandler(BasicBootstrap bootstrap) throws IllegalArgumentException {
        if (bootstrap == null) {
            throw new IllegalArgumentException("Bootstrap is required");
        }
        this.setBootstrap(bootstrap);
    }

    public final void handleEvent(LifecycleState state) throws LifecycleEventException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Handling server state change to: " + state));
        }
        Kernel kernel = this.getBootstrap().getKernel();
        KernelEventManager eventMgr = kernel.getEventManager();
        long currentTime = System.currentTimeMillis();
        String type = this.getNotificationType();
        AbstractEvent event = new AbstractEvent((Object)eventMgr, type, 0L, currentTime, (Object)new Long(currentTime));
        eventMgr.fireKernelEvent((KernelEvent)event);
        log.debug((Object)("Fired: " + event));
    }

    protected abstract String getNotificationType();

    private BasicBootstrap getBootstrap() {
        return this.bootstrap;
    }

    private void setBootstrap(BasicBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }
}

