/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.as.config;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.bootstrap.api.as.config.JBossASBasedServerConfig;
import org.jboss.bootstrap.api.config.InvalidConfigurationException;
import org.jboss.bootstrap.impl.base.config.AbstractBasicConfigurationValidator;
import org.jboss.bootstrap.spi.config.ConfigurationValidator;
import org.jboss.logging.Logger;

public class JBossASBasedConfigurationValidator<T extends JBossASBasedServerConfig<T>>
extends AbstractBasicConfigurationValidator<T>
implements ConfigurationValidator<T> {
    private static final Logger log = Logger.getLogger(JBossASBasedConfigurationValidator.class);

    public void validate(T config) throws InvalidConfigurationException {
        if (config == null) {
            throw new IllegalArgumentException("Configuration is required, but was not supplied");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Validating Configuration: " + config + " ..."));
        }
        super.validate(config);
        String name = config.getBootstrapName();
        URL home = config.getBootstrapHome();
        URL direct = config.getBootstrapUrl();
        if (direct == null && (home == null || name == null || name.length() == 0)) {
            throw new InvalidConfigurationException("If the bootstrap URL is not specified, both the bootstrap home and name must be.");
        }
        this.require(config.getJBossHome(), "jboss.home");
        this.require(config.getBindAddress(), "jboss.bind.address");
        this.require(config.getServerName(), "jboss.server.name");
        this.require(config.getBootLibraryLocation(), "jboss.lib.url");
        this.require(config.getServerBaseLocation(), "jboss.server.base.url");
        this.require(config.getServerHomeLocation(), "jboss.server.home.url");
        this.require(config.getCommonBaseLocation(), "jboss.common.base.url");
        this.require(config.getCommonLibLocation(), "jboss.common.lib.url");
        this.require(config.getServerLogLocation(), "jboss.server.log.dir", false);
        this.require(config.getServerConfLocation(), "jboss.server.config.url");
        this.require(config.getServerLibLocation(), "jboss.server.lib.url");
        this.require(config.getServerDataLocation(), "jboss.server.data.dir", false);
        this.require(config.getServerTempLocation(), "jboss.server.temp.dir", false);
        this.require(config.getPartitionName(), "jboss.partition.name");
        this.require(config.isLoadNative(), "jboss.native.load");
        this.require(config.getNativeLibraryLocation(), "jboss.native.dir", false);
        this.require(config.isUsePlatformMBeanServer(), "jboss.platform.mbeanserver");
        log.debug((Object)("Configuration is valid: " + config));
    }

    protected void require(String arg, String propertyName) throws InvalidConfigurationException {
        if (arg == null || arg.length() == 0) {
            throw new InvalidConfigurationException(propertyName + " must be specified");
        }
    }

    protected void require(Boolean arg, String propertyName) throws InvalidConfigurationException {
        if (arg == null) {
            throw new InvalidConfigurationException(propertyName + " must be specified");
        }
    }

    protected void require(URL arg, String propertyName) throws InvalidConfigurationException {
        this.require(arg, propertyName, true);
    }

    protected void require(URL arg, String propertyName, boolean exists) throws InvalidConfigurationException {
        if (arg == null) {
            throw new InvalidConfigurationException(propertyName + " must be specified");
        }
        if (exists) {
            try {
                URLConnection connection = arg.openConnection();
                connection.connect();
            }
            catch (IOException ioe) {
                throw new InvalidConfigurationException("Could not get a connection to the " + propertyName + ": " + arg.toExternalForm(), (Throwable)ioe);
            }
        }
    }
}

