/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.base.server;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.bootstrap.spi.Bootstrap;
import org.jboss.bootstrap.spi.config.ConfigurationInitializer;
import org.jboss.bootstrap.spi.config.ConfigurationValidator;
import org.jboss.bootstrap.spi.config.InvalidConfigurationException;
import org.jboss.bootstrap.spi.config.ServerConfig;
import org.jboss.bootstrap.spi.lifecycle.LifecycleState;
import org.jboss.bootstrap.spi.server.Server;
import org.jboss.bootstrap.spi.server.ServerInitializer;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServer<K extends Server<K, T>, T extends ServerConfig<T>>
implements Server<K, T> {
    private static final Logger log = Logger.getLogger(AbstractServer.class);
    private LifecycleState state;
    private T configuration;
    private ConfigurationValidator<T> validator;
    private ConfigurationInitializer<T> configInitializer;
    private ServerInitializer<K, T> serverInitializer;
    private final List<Bootstrap> bootstraps = new CopyOnWriteArrayList<Bootstrap>();
    private final List<Bootstrap> startedBootstraps = new CopyOnWriteArrayList<Bootstrap>();

    protected AbstractServer() {
        this(null);
    }

    protected AbstractServer(T configuration) {
        this.setConfiguration(configuration);
        this.setState(LifecycleState.PRE_INIT);
    }

    public final T getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(T configuration) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Set configuration: " + configuration));
        }
        this.configuration = configuration;
    }

    public final synchronized LifecycleState getState() {
        LifecycleState state = this.state;
        if (state == null) {
            throw new IllegalStateException("null state");
        }
        return state;
    }

    public void shutdown() throws IllegalStateException, Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Received request to shutdown");
        }
        LifecycleState required = LifecycleState.STARTED;
        LifecycleState actual = this.getState();
        this.checkState(required, actual);
        log.info((Object)("Stopping: " + this));
        this.setState(LifecycleState.STOPPING);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Shutting down bootstraps");
        }
        this.shutdownBootstraps();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Calling implementation class shutdown...");
        }
        this.doShutdown();
        ServerInitializer<K, T> serverInitializer = this.getServerInitializer();
        if (serverInitializer != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Calling to clean up for shutdown: " + serverInitializer));
            }
            serverInitializer.cleanup((Server)this);
        }
        log.info((Object)("Stopped: " + this));
        this.setState(LifecycleState.IDLE);
    }

    public void start() throws IllegalStateException, Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Received request to start");
        }
        if (this.getState().equals((Object)LifecycleState.PRE_INIT)) {
            log.debug((Object)"Invoking implicit initialization from start()");
            this.initialize();
        }
        LifecycleState required = LifecycleState.IDLE;
        LifecycleState actual = this.getState();
        this.checkState(required, actual);
        log.info((Object)("Starting: " + this));
        this.setState(LifecycleState.STARTING);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering implementation class start...");
        }
        this.doStart();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Starting bootstraps...");
        }
        this.startBootstraps();
        log.info((Object)("Started: " + this));
        this.setState(LifecycleState.STARTED);
    }

    public void addBootstrap(Bootstrap bootstrap) throws IllegalStateException, IllegalArgumentException {
        if (bootstrap == null) {
            throw new IllegalArgumentException("Supplied bootstrap was null");
        }
        this.getBootstraps().add(bootstrap);
    }

    public void removeBootstrap(Bootstrap bootstrap) throws IllegalStateException, IllegalArgumentException {
        boolean removed = this.bootstraps.remove(bootstrap);
        if (!removed) {
            throw new IllegalArgumentException("Specified bootstrap could not be removed because it is not present in the list");
        }
    }

    public ConfigurationValidator<T> getValidator() {
        return this.validator;
    }

    public synchronized void initialize() throws IllegalStateException, InvalidConfigurationException {
        log.debug((Object)("Initializing server: " + this));
        LifecycleState state = this.getState();
        if (!state.equals((Object)LifecycleState.PRE_INIT)) {
            throw new IllegalStateException("Cannot initialize an already initialized server, state is: " + state);
        }
        T config = this.getConfiguration();
        if (config == null) {
            throw new IllegalStateException("Configuration must be supplied before server is initialized");
        }
        ConfigurationInitializer<T> configInitializer = this.getConfigInitializer();
        if (configInitializer != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Performing configuration initialization...");
            }
            configInitializer.initialize(config);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)"No configuration initializer supplied, skipping");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Validating config...");
        }
        this.validate(config);
        ServerInitializer<K, T> serverInitializer = this.getServerInitializer();
        if (serverInitializer != null) {
            serverInitializer.initialize((Server)this);
        } else {
            log.debug((Object)("No initializer defined, skipping initialization of " + this));
        }
        config.freeze();
        this.setState(LifecycleState.IDLE);
    }

    public final synchronized ServerInitializer<K, T> getServerInitializer() {
        return this.serverInitializer;
    }

    public final synchronized void setServerInitializer(ServerInitializer<K, T> serverInitializer) throws IllegalStateException {
        this.checkState(LifecycleState.PRE_INIT, this.getState());
        this.serverInitializer = serverInitializer;
        log.debug((Object)("Set server initializer to " + serverInitializer));
    }

    public final synchronized ConfigurationInitializer<T> getConfigInitializer() {
        return this.configInitializer;
    }

    public final synchronized void setConfigInitializer(ConfigurationInitializer<T> configInitializer) {
        this.checkState(LifecycleState.PRE_INIT, this.getState());
        this.configInitializer = configInitializer;
        log.debug((Object)("Set config initializer to " + configInitializer));
    }

    public final synchronized void setValidator(ConfigurationValidator<T> validator) {
        this.checkState(LifecycleState.PRE_INIT, this.getState());
        log.debug((Object)("Setting validator to: " + validator));
        this.validator = validator;
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doShutdown() throws Exception;

    protected void startBootstraps() throws Exception {
        for (Bootstrap bootstrap : this.getBootstraps()) {
            this.getStartedBootstraps().add(0, bootstrap);
            bootstrap.start((Server)this);
        }
    }

    protected void shutdownBootstraps() {
        List<Bootstrap> startedBootstraps = this.getStartedBootstraps();
        for (Bootstrap bootstrap : startedBootstraps) {
            bootstrap.prepareShutdown((Server)this);
        }
        for (Bootstrap bootstrap : startedBootstraps) {
            try {
                bootstrap.shutdown((Server)this);
            }
            catch (Throwable t) {
                log.warn((Object)("Error shutting down bootstrap: " + bootstrap), t);
            }
        }
    }

    private void checkState(LifecycleState required, LifecycleState actual) throws IllegalStateException {
        if (required != actual) {
            throw new IllegalStateException("Server must be in " + LifecycleState.class.getSimpleName() + " " + required + "; is instead: " + actual);
        }
    }

    private void validate(T configuration) throws InvalidConfigurationException, IllegalArgumentException {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration was not specified");
        }
        ConfigurationValidator<T> validator = this.getValidator();
        if (validator != null) {
            log.debug((Object)("Validating configuration using: " + validator));
            validator.validate(this.getConfiguration());
        } else if (log.isTraceEnabled()) {
            log.trace((Object)"No validator defined, skipping validation upon configuration");
        }
    }

    private List<Bootstrap> getBootstraps() {
        return this.bootstraps;
    }

    private List<Bootstrap> getStartedBootstraps() {
        return this.startedBootstraps;
    }

    private final synchronized void setState(LifecycleState state) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting " + LifecycleState.class.getSimpleName() + " to: " + state));
        }
        this.state = state;
    }
}

