/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.base.server;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.jboss.bootstrap.impl.base.server.SecurityActions;
import org.jboss.bootstrap.spi.config.ServerConfig;
import org.jboss.bootstrap.spi.lifecycle.LifecycleState;
import org.jboss.bootstrap.spi.server.Server;
import org.jboss.bootstrap.spi.server.ServerInitializer;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicServerInitializer<K extends Server<K, T>, T extends ServerConfig<T>>
implements ServerInitializer<K, T> {
    private static final Logger log = Logger.getLogger(AbstractBasicServerInitializer.class);
    private static final Set<String> SYS_PROPS_ADDED = new HashSet<String>();

    public synchronized void initialize(K server) throws IllegalArgumentException, IllegalStateException {
        LifecycleState required;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Request to initialize " + server + " using: " + this));
        }
        if (server == null) {
            throw new IllegalArgumentException("Server must be specified");
        }
        LifecycleState state = server.getState();
        if (!state.equals((Object)(required = LifecycleState.PRE_INIT))) {
            throw new IllegalStateException(this + " may only be invoked when " + LifecycleState.class.getSimpleName() + " is " + required + ", was: " + state);
        }
        ServerConfig config = server.getConfiguration();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting system properties for " + server));
        }
        this.setSystemProperties(config);
        log.debug((Object)("Initialized " + server + ": " + this));
    }

    public synchronized void cleanup(K server) throws IllegalArgumentException, IllegalStateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Preparing for shutdown...");
        }
        log.debug((Object)"Clearing all system properties set in initialization...");
        for (String sysProp : SYS_PROPS_ADDED) {
            SecurityActions.clearSystemProperty(sysProp);
        }
    }

    protected void setSystemProperties(T configuration) {
        this.setSystemProperty("jboss.bootstrap.home.url", configuration.getBootstrapHome());
        this.setSystemProperty("jboss.bootstrap.url", configuration.getBootstrapUrl());
        this.setSystemProperty("jboss.bootstrap.name", configuration.getBootstrapName());
    }

    protected final void setSystemProperty(String key, URL value) {
        String urlString = value != null ? value.toExternalForm() : "";
        this.setSystemProperty(key, urlString == null ? null : urlString);
    }

    protected final void setSystemProperty(String key, Integer value) {
        String string = value != null ? value.toString() : "";
        this.setSystemProperty(key, string == null ? null : string);
    }

    protected final void setSystemProperty(String key, Boolean value) {
        String string = value != null ? value.toString() : "";
        this.setSystemProperty(key, string == null ? null : string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSystemProperty(String key, String value) {
        assert (key != null) : "Key for system property was null";
        if (value == null || "".equals(value)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Not setting system property for key " + key + " as value was blank or null"));
            }
            return;
        }
        SecurityActions.setSystemProperty(key, value);
        AbstractBasicServerInitializer abstractBasicServerInitializer = this;
        synchronized (abstractBasicServerInitializer) {
            SYS_PROPS_ADDED.add(key);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Set system property \"" + key + "\" to: " + (value != null ? "\"" + value + "\"" : "[EMPTY]")));
        }
    }
}

