/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.impl.base.server;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import org.jboss.bootstrap.impl.base.server.SecurityActions;
import org.jboss.bootstrap.spi.Bootstrap;
import org.jboss.bootstrap.spi.config.ConfigurationInitializer;
import org.jboss.bootstrap.spi.config.ConfigurationValidator;
import org.jboss.bootstrap.spi.config.InvalidConfigurationException;
import org.jboss.bootstrap.spi.config.ServerConfig;
import org.jboss.bootstrap.spi.lifecycle.LifecycleEventException;
import org.jboss.bootstrap.spi.lifecycle.LifecycleEventHandler;
import org.jboss.bootstrap.spi.lifecycle.LifecycleState;
import org.jboss.bootstrap.spi.server.Server;
import org.jboss.bootstrap.spi.server.ServerInitializer;
import org.jboss.logging.Logger;
import org.jboss.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServer<K extends Server<K, T>, T extends ServerConfig<T>>
extends NotificationBroadcasterSupport
implements Server<K, T>,
NotificationBroadcaster {
    private static final Logger log = Logger.getLogger(AbstractServer.class);
    private Class<K> actualClass;
    private volatile LifecycleState state;
    private volatile T configuration;
    private ConfigurationValidator<T> validator;
    private volatile ConfigurationInitializer<T> configInitializer;
    private volatile ServerInitializer<K, T> serverInitializer;
    private final List<Bootstrap<K, T>> bootstraps = new CopyOnWriteArrayList<Bootstrap<K, T>>();
    private final List<Bootstrap<K, T>> startedBootstraps = new CopyOnWriteArrayList<Bootstrap<K, T>>();
    private final Map<LifecycleState, Set<LifecycleEventHandler>> eventHandlers = new ConcurrentHashMap<LifecycleState, Set<LifecycleEventHandler>>();
    private volatile Thread startupThread = null;

    protected AbstractServer(Class<K> actualClass) throws IllegalArgumentException {
        this(actualClass, null);
    }

    protected AbstractServer(Class<K> actualClass, T configuration) throws IllegalArgumentException {
        if (actualClass == null) {
            throw new IllegalArgumentException("Actual class must be specified");
        }
        Object configToSet = configuration;
        if (configToSet == null) {
            log.debug((Object)"No configuration has been supplied, so making a default one");
            ServerConfig newConfiguration = null;
            Class<T> configClass = this.getDefaultServerConfigClass();
            try {
                newConfiguration = (ServerConfig)SecurityActions.newInstance(configClass);
                log.debug((Object)("Created new default configuration: " + newConfiguration));
            }
            catch (Throwable t) {
                throw new RuntimeException("Could not create default configuration of type " + configClass, t);
            }
            configToSet = newConfiguration;
        }
        this.setActualClass(actualClass);
        this.setConfiguration(configToSet);
        this.state = LifecycleState.INSTANCIATED;
    }

    public T getConfiguration() {
        return this.configuration;
    }

    public synchronized void setConfiguration(T configuration) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Set configuration: " + configuration));
        }
        this.configuration = configuration;
    }

    public final LifecycleState getState() {
        LifecycleState state = this.state;
        if (state == null) {
            throw new IllegalStateException("null state");
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IllegalStateException, Exception {
        Thread startupThread;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Received request to shutdown");
        }
        if ((startupThread = this.startupThread) != null) {
            startupThread.interrupt();
            try {
                startupThread.join();
            }
            catch (InterruptedException ie) {
                log.warn((Object)"Interrupted while shutdown is waiting for server startup to complete");
                Thread.interrupted();
            }
        }
        AbstractServer abstractServer = this;
        synchronized (abstractServer) {
            LifecycleState required = LifecycleState.STARTED;
            LifecycleState actual = this.getState();
            this.checkState(required, actual);
            log.info((Object)("Stopping: " + this));
            StopWatch watch = new StopWatch(true);
            this.setState(LifecycleState.STOPPING);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Shutting down bootstraps");
            }
            this.shutdownBootstraps();
            if (log.isTraceEnabled()) {
                log.trace((Object)"Calling implementation class shutdown...");
            }
            this.doShutdown();
            ServerInitializer<K, T> serverInitializer = this.getServerInitializer();
            if (serverInitializer != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Calling to clean up for shutdown: " + serverInitializer));
                }
                serverInitializer.cleanup(this.covarientReturn());
            }
            this.sendStopJmxNotification();
            log.info((Object)("Stopped: " + this + " in " + watch));
            this.setState(LifecycleState.STOPPED);
            this.setState(LifecycleState.IDLE);
        }
    }

    public void start() throws IllegalStateException, Exception {
        Thread thread;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Received request to start");
        }
        if (this.getState().equals((Object)LifecycleState.INSTANCIATED)) {
            log.debug((Object)"Invoking implicit initialization from start()");
            this.initialize();
        }
        StartServerTask task = new StartServerTask();
        this.startupThread = thread = new Thread(task);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        Exception exceptionOnStart = task.getException();
        if (exceptionOnStart != null) {
            throw exceptionOnStart;
        }
    }

    public void addBootstrap(Bootstrap<K, T> bootstrap) throws IllegalStateException, IllegalArgumentException {
        if (bootstrap == null) {
            throw new IllegalArgumentException("Supplied bootstrap was null");
        }
        this.getBootstraps().add(bootstrap);
    }

    public void removeBootstrap(Bootstrap<K, T> bootstrap) throws IllegalStateException, IllegalArgumentException {
        boolean removed = this.bootstraps.remove(bootstrap);
        if (!removed) {
            throw new IllegalArgumentException("Specified bootstrap could not be removed because it is not present in the list");
        }
    }

    public ConfigurationValidator<T> getValidator() {
        return this.validator;
    }

    public synchronized void initialize() throws IllegalStateException, InvalidConfigurationException, LifecycleEventException {
        LifecycleState state = this.getState();
        if (!state.equals((Object)LifecycleState.INSTANCIATED)) {
            throw new IllegalStateException("Cannot initialize an already initialized server, state is: " + state);
        }
        T config = this.getConfiguration();
        if (config == null) {
            throw new IllegalStateException("Configuration must be supplied before server is initialized");
        }
        log.debug((Object)("Initializing server: " + this));
        this.setState(LifecycleState.PRE_INIT);
        ConfigurationInitializer<T> configInitializer = this.getConfigInitializer();
        if (configInitializer != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Performing configuration initialization...");
            }
            configInitializer.initialize(config);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)"No configuration initializer supplied, skipping");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Validating config...");
        }
        this.validate(config);
        ServerInitializer<K, T> serverInitializer = this.getServerInitializer();
        if (serverInitializer != null) {
            serverInitializer.initialize(this.covarientReturn());
        } else {
            log.debug((Object)("No initializer defined, skipping initialization of " + this));
        }
        config.freeze();
        this.setState(LifecycleState.INITIALIZED);
        this.setState(LifecycleState.IDLE);
    }

    public final ServerInitializer<K, T> getServerInitializer() {
        return this.serverInitializer;
    }

    public final synchronized void setServerInitializer(ServerInitializer<K, T> serverInitializer) throws IllegalStateException {
        this.checkMutable(this.getState());
        this.serverInitializer = serverInitializer;
        log.debug((Object)("Set server initializer to " + serverInitializer));
    }

    public final ConfigurationInitializer<T> getConfigInitializer() {
        return this.configInitializer;
    }

    public final synchronized void setConfigInitializer(ConfigurationInitializer<T> configInitializer) {
        this.checkMutable(this.getState());
        this.configInitializer = configInitializer;
        log.debug((Object)("Set config initializer to " + configInitializer));
    }

    public final synchronized void setValidator(ConfigurationValidator<T> validator) {
        this.checkMutable(this.getState());
        log.debug((Object)("Setting validator to: " + validator));
        this.validator = validator;
    }

    public void registerEventHandler(LifecycleState state, LifecycleEventHandler handler) throws IllegalArgumentException {
        this.registerEventHandlers(state, handler);
    }

    public void registerEventHandler(LifecycleEventHandler handler, EnumSet<LifecycleState> states) throws IllegalArgumentException {
        if (handler == null) {
            throw new IllegalArgumentException("handler is required");
        }
        if (states == null) {
            throw new IllegalArgumentException("states is required");
        }
        for (LifecycleState state : states) {
            this.registerEventHandler(state, handler);
        }
    }

    public void registerEventHandler(LifecycleEventHandler handler, LifecycleState ... states) throws IllegalArgumentException {
        if (handler == null) {
            throw new IllegalArgumentException("handler is required");
        }
        if (states == null) {
            throw new IllegalArgumentException("states is required");
        }
        for (LifecycleState state : states) {
            this.registerEventHandler(state, handler);
        }
    }

    public void registerEventHandlers(LifecycleState state, LifecycleEventHandler ... handlers) throws IllegalArgumentException {
        if (handlers == null) {
            throw new IllegalArgumentException("At least one handler is required");
        }
        if (state == null) {
            throw new IllegalArgumentException("state is required");
        }
        Set<LifecycleEventHandler> handlersForEvent = this.getHandlersForEvent(state);
        for (LifecycleEventHandler handler : handlers) {
            handlersForEvent.add(handler);
            log.debug((Object)("Added lifecycle handler " + handler + " to fire upon state change to " + state + " for " + this));
        }
    }

    public boolean unregisterEventHandler(LifecycleEventHandler handler, LifecycleState state) throws IllegalArgumentException {
        Set<LifecycleEventHandler> handlers = this.getHandlersForEvent(state);
        boolean removed = handlers.remove(handler);
        log.debug((Object)("Removed lifecycle handler " + handler + " from firing upon state change to " + state + " for " + this));
        return removed;
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doShutdown() throws Exception;

    protected abstract Class<? extends T> getDefaultServerConfigClass();

    protected void sendStartJmxNotification() {
        this.sendNotificationWithCurrentTimeUserData("org.jboss.system.server.started", 1);
    }

    protected void sendStopJmxNotification() {
        this.sendNotificationWithCurrentTimeUserData("org.jboss.system.server.stopped", 2);
    }

    protected final void sendNotificationWithCurrentTimeUserData(String type, int sequenceNumber) {
        Notification startNotification = new Notification(type, this, sequenceNumber);
        startNotification.setUserData(System.currentTimeMillis());
        this.sendNotification(startNotification);
        log.debug((Object)("Sent JMX Notification: " + type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startBootstraps() throws Exception {
        K typedServer = this.covarientReturn();
        for (Bootstrap<K, T> bootstrap : this.getBootstraps()) {
            this.getStartedBootstraps().add(0, bootstrap);
            ClassLoader oldCl = SecurityActions.getThreadContextClassLoader();
            ClassLoader bootstrapCl = bootstrap.getClass().getClassLoader();
            try {
                SecurityActions.setThreadContextClassLoader(bootstrapCl);
                bootstrap.start(typedServer);
            }
            finally {
                SecurityActions.setThreadContextClassLoader(oldCl);
            }
        }
    }

    protected void shutdownBootstraps() {
        List<Bootstrap<K, T>> startedBootstraps = this.getStartedBootstraps();
        K typedServer = this.covarientReturn();
        for (Bootstrap<K, T> bootstrap : startedBootstraps) {
            bootstrap.prepareShutdown(typedServer);
        }
        for (Bootstrap<K, T> bootstrap : startedBootstraps) {
            try {
                bootstrap.shutdown(typedServer);
            }
            catch (Throwable t) {
                log.warn((Object)("Error shutting down bootstrap: " + bootstrap), t);
            }
        }
    }

    protected final K covarientReturn() {
        Class<K> actualClass = this.getActualClass();
        try {
            return (K)((Server)actualClass.cast(this));
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Actual class is incorrect and " + actualClass + " was not assignable to this instance: " + this, cce);
        }
    }

    private Set<LifecycleEventHandler> getHandlersForEvent(LifecycleState state) throws IllegalArgumentException {
        if (state == null) {
            throw new IllegalArgumentException("state is required");
        }
        Set<LifecycleEventHandler> handlers = this.eventHandlers.get(state);
        if (handlers == null) {
            handlers = new CopyOnWriteArraySet<LifecycleEventHandler>();
            this.eventHandlers.put(state, handlers);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Placed empty backing map for lifecycle event handers upon state change into " + state + " for: " + this));
            }
        }
        return handlers;
    }

    private void checkState(LifecycleState required, LifecycleState actual) throws IllegalStateException {
        if (required != actual) {
            throw new IllegalStateException("Server must be in " + LifecycleState.class.getSimpleName() + " " + required + "; is instead: " + actual);
        }
    }

    private void checkState(LifecycleState[] required, LifecycleState actual) throws IllegalStateException {
        for (LifecycleState current : required) {
            if (!current.equals((Object)actual)) continue;
            return;
        }
        throw new IllegalStateException("Server state must be in one of " + Arrays.asList(required) + "; is instead: " + actual);
    }

    private void checkMutable(LifecycleState state) {
        this.checkState(new LifecycleState[]{LifecycleState.INSTANCIATED, LifecycleState.PRE_INIT}, state);
    }

    private void validate(T configuration) throws InvalidConfigurationException, IllegalArgumentException {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration was not specified");
        }
        ConfigurationValidator<T> validator = this.getValidator();
        if (validator != null) {
            log.debug((Object)("Validating configuration using: " + validator));
            validator.validate(this.getConfiguration());
        } else if (log.isTraceEnabled()) {
            log.trace((Object)"No validator defined, skipping validation upon configuration");
        }
    }

    private List<Bootstrap<K, T>> getBootstraps() {
        return this.bootstraps;
    }

    private List<Bootstrap<K, T>> getStartedBootstraps() {
        return this.startedBootstraps;
    }

    protected final Class<K> getActualClass() {
        return this.actualClass;
    }

    private void setActualClass(Class<K> actualClass) {
        this.actualClass = actualClass;
    }

    private final synchronized void setState(LifecycleState state) throws LifecycleEventException, IllegalArgumentException {
        if (state == null) {
            throw new IllegalArgumentException("State was not specified");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting " + LifecycleState.class.getSimpleName() + " to: " + state));
        }
        this.state = state;
        Set<LifecycleEventHandler> handlers = this.getHandlersForEvent(state);
        for (LifecycleEventHandler handler : handlers) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Firing event handler for state change to " + state + ": " + handler));
                }
                handler.handleEvent(state);
            }
            catch (LifecycleEventException t) {
                log.error((Object)("Encountered problem in firing event handler " + handler + " for state change to " + state + " in " + this), (Throwable)t);
                throw t;
            }
        }
    }

    class StartServerTask
    implements Runnable {
        private Exception exception;

        StartServerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractServer thisRef;
            AbstractServer abstractServer = thisRef = AbstractServer.this;
            synchronized (abstractServer) {
                try {
                    LifecycleState required = LifecycleState.IDLE;
                    LifecycleState actual = AbstractServer.this.getState();
                    AbstractServer.this.checkState(required, actual);
                    log.info((Object)("Starting: " + thisRef));
                    StopWatch watch = new StopWatch(true);
                    AbstractServer.this.setState(LifecycleState.STARTING);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Entering implementation class start...");
                    }
                    AbstractServer.this.doStart();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Starting bootstraps...");
                    }
                    AbstractServer.this.startBootstraps();
                    AbstractServer.this.sendStartJmxNotification();
                    log.info((Object)("Started: " + thisRef + " in " + watch));
                    AbstractServer.this.setState(LifecycleState.STARTED);
                }
                catch (Exception e) {
                    log.debug((Object)("Encountered exception while starting, caching it to be thrown later: " + e));
                    this.exception = e;
                    return;
                }
                finally {
                    AbstractServer.this.startupThread = null;
                }
            }
        }

        Exception getException() {
            return this.exception;
        }
    }
}

