/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.spi.as.server;

import org.jboss.bootstrap.spi.as.config.JBossASServerConfig;
import org.jboss.bootstrap.spi.as.config.JBossASServerConfigFactory;
import org.jboss.bootstrap.spi.as.server.JBossASServer;
import org.jboss.bootstrap.spi.as.server.SecurityActions;
import org.jboss.bootstrap.spi.config.ServerConfig;
import org.jboss.bootstrap.spi.factory.ServerFactory;
import org.jboss.bootstrap.spi.server.Server;

public class JBossASServerFactory {
    public static final String DEFAULT_AS_SERVER_IMPL_CLASS_NAME = "org.jboss.bootstrap.impl.as.server.JBossASServerImpl";

    private JBossASServerFactory() {
    }

    public static JBossASServer createServer() {
        return JBossASServerFactory.createServer(SecurityActions.getTccl());
    }

    public static JBossASServer createServerWithDefaultConfiguration() {
        return JBossASServerFactory.createServerWithDefaultConfiguration(SecurityActions.getTccl());
    }

    public static JBossASServer createServer(ClassLoader cl) throws IllegalArgumentException {
        try {
            return JBossASServerFactory.createServer(DEFAULT_AS_SERVER_IMPL_CLASS_NAME, cl);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in creating the Server", e);
        }
    }

    public static JBossASServer createServerWithDefaultConfiguration(ClassLoader cl) throws IllegalArgumentException {
        try {
            return JBossASServerFactory.createServerWithDefaultConfiguration(DEFAULT_AS_SERVER_IMPL_CLASS_NAME, cl);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in creating the Server", e);
        }
    }

    public static JBossASServer createServer(String implClassName, ClassLoader cl) throws IllegalArgumentException, Exception {
        if (cl == null) {
            throw new IllegalArgumentException(ClassLoader.class.getSimpleName() + " is required.");
        }
        if (implClassName == null || implClassName.length() == 0) {
            throw new IllegalArgumentException("Implementation class name must be specified");
        }
        Server server = ServerFactory.createServer((String)implClassName, (ClassLoader)cl);
        Class<JBossASServer> targetClass = JBossASServer.class;
        JBossASServer asServer = null;
        try {
            asServer = (JBossASServer)targetClass.cast(server);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Specified server implementation class, " + implClassName + " must be assignable to " + targetClass.getName());
        }
        JBossASServerConfig config = JBossASServerConfigFactory.createServerConfig(cl);
        asServer.setConfiguration((ServerConfig)config);
        return asServer;
    }

    public static JBossASServer createServerWithDefaultConfiguration(String implClassName, ClassLoader cl) throws IllegalArgumentException, Exception {
        return JBossASServerFactory.applyDefaultConfiguration(JBossASServerFactory.createServer(implClassName, cl), cl);
    }

    private static JBossASServer applyDefaultConfiguration(JBossASServer server, ClassLoader cl) {
        JBossASServerConfig config = JBossASServerConfigFactory.createServerConfig(cl);
        server.setConfiguration((ServerConfig)config);
        return server;
    }
}

