/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.bootstrap.spi.as.config;

import org.jboss.bootstrap.api.as.config.JBossASBasedServerConfig;
import org.jboss.bootstrap.spi.config.ConfigurationInitializer;
import org.jboss.bootstrap.spi.server.ServerInitializer;

/**
 * JBossASBasedConfigurationInitializer
 * 
 * Contract for a JBossAS-based Configuration Initializers 
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 * @see {@link ServerInitializer}
 */
public interface JBossASBasedConfigurationInitializer<T extends JBossASBasedServerConfig<T>>
      extends
         ConfigurationInitializer<T>
{
   //-------------------------------------------------------------------------------||
   // Constants --------------------------------------------------------------------||
   //-------------------------------------------------------------------------------||

   /*
    * The following denote default values in the case
    * a property is not explicitly-specified
    */
   
   /**
    * The default value of the name of the bootstrap file
    */
   String VALUE_BOOTSTRAP_NAME_DEFAULT = "bootstrap.xml";

   /**
    * Default address which will be set 
    * if {@link JBossASBasedServerConfig#getBindAddress()} or
    * system or configuration property
    * {@link JBossASBasedServerConfig#PROP_KEY_JBOSSAS_BIND_ADDRESS}
    * is not defined
    */
   String VALUE_BIND_ADDRESS_DEFAULT = "127.0.0.1";

   /**
    * Value for address representing any/all interfaces
    */
   String VALUE_BIND_ADDRESS_ANY = "0.0.0.0";

   /**
    * Default server name which will be set if
    * {@link JBossASBasedServerConfig#getBindAddress()} or
    * system or configuration property
    * {@link JBossASBasedServerConfig#PROP_KEY_JBOSSAS_SERVER_NAME}
    * is not defined
    */
   String VALUE_SERVER_NAME_DEFAULT = "default";

   /**
    * The suffix used when generating the default value for 
    * {@link JBossASBasedServerConfig#PROP_KEY_JBOSSAS_BOOT_LIBRARY_URL},
    * {@link JBossASBasedServerConfig#PROP_KEY_JBOSSAS_COMMON_LIBRARY_URL} and 
    * {@link #PROP_KEY_JBOSSAS_SERVER_LIBRARY_URL}.
    */
   String VALUE_LIBRARY_URL_SUFFIX_DEFAULT = "lib/";

   /**
    * The suffix used when generating the default value for 
    * {@link JBossASBasedServerConfig#PROP_KEY_JBOSSAS_SERVER_BASE_URL}.
    */
   String VALUE_SERVER_BASE_URL_SUFFIX_DEFAULT = "server/";

   /**
    * The suffix used when generating the default value for 
    * {@link JBossASBasedServerConfig#PROP_KEY_JBOSSAS_COMMON_BASE_URL}
    */
   String VALUE_COMMON_BASE_URL_SUFFIX_DEFAULT = "common/";

   /**
    * The suffix used when generating the default value for 
    * {@link JBossASBasedServerConfig#PROP_KEY_JBOSSAS_SERVER_LOG_DIR}.
    */
   String VALUE_SERVER_LOG_DIR_SUFFIX_DEFAULT = "log/";

   /**
    * The suffix used when generating the default value for 
    * {@link JBossASBasedServerConfig#PROP_KEY_JBOSSAS_SERVER_CONF_URL}.
    */
   String VALUE_SERVER_CONFIG_URL_SUFFIX_DEFAULT = "conf/";

   /**
    * The suffix used when generating the default value for 
    * {@link JBossASBasedServerConfig#PROP_KEY_JBOSSAS_SERVER_DATA_DIR}.
    */
   String VALUE_SERVER_DATA_DIR_SUFFIX_DEFAULT = "data/";

   /**
    * The suffix used when generating the default value for 
    * {@link JBossASBasedServerConfig#PROP_KEY_JBOSSAS_SERVER_TEMP_DIR}.
    */
   String VALUE_SERVER_TEMP_DIR_SUFFIX_DEFAULT = "tmp/";

   /** 
    * The partition name used as the default value for
    * {@link JBossASBasedServerConfig#PROP_KEY_JBOSSAS_PARTITION_NAME} 
    */
   String VALUE_PARTITION_NAME_DEFAULT = "DefaultPartition";

   /**
    * The default value for
    * {@link JBossASBasedServerConfig#PROP_KEY_JBOSSAS_NATIVE_LOAD}
    */
   Boolean VALUE_NATIVE_LOAD_DEFAULT = false;

   /**
    * The default suffix used to construct native libaray
    * locations, relative to the Server Temp Home
    * (eg. $JBOSS_HOME/server/[serverName]/tmp/native/)
    */
   String VALUE_NATIVE_DIR_SUFFIX_DEFAULT = "native/";

   /**
    * The default value used in determining whether or not
    * to use the Platform MBean Server under JDK 1.5+ 
    */
   Boolean VALUE_PLATFORM_MBEAN_SERVER_DEFAULT = true;
}
