/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.spi.factory;

import org.jboss.bootstrap.spi.factory.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericFactory {
    private GenericFactory() {
    }

    static final <T> T createInstance(String implClassName, ClassLoader cl, Class<T> expectedType) throws IllegalArgumentException, Exception {
        if (implClassName == null || implClassName.length() == 0) {
            throw new IllegalArgumentException("Implementation class must be specified");
        }
        if (cl == null) {
            throw new IllegalArgumentException(ClassLoader.class.getSimpleName() + " must be specified");
        }
        if (expectedType == null) {
            throw new IllegalArgumentException("Expected type must be specified");
        }
        Class<?> implClass = null;
        try {
            implClass = Class.forName(implClassName, false, cl);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Specified implementation class could not be found: " + implClassName + " on " + ClassLoader.class.getSimpleName() + " " + cl, cnfe);
        }
        Object obj = SecurityActions.newInstance(implClass, cl);
        try {
            return expectedType.cast(obj);
        }
        catch (ClassCastException cce) {
            ClassLoader implCl = implClass.getClassLoader();
            ClassLoader expectedTypeCl = expectedType.getClassLoader();
            throw new ClassCastException("Specified implementation class, " + implClassName + ", resolved to " + implClass + " on " + implCl + " is not of type " + expectedType + " from " + ClassLoader.class.getSimpleName() + ": " + (expectedTypeCl == null ? "[BOOTSTRAP CL]" : expectedTypeCl));
        }
    }
}

