/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.model.metric;

import java.util.Calendar;
import java.util.Date;

public final class Timespan {
    private long start;
    private long end;
    public static final String LAST_24_HOURS = "Last 24 Hours";
    public static final String LAST_DAY = "Last Day";
    public static final String LAST_7_DAYS = "Last 7 Days";
    public static final String LAST_WEEK = "Last Week";
    public static final String LAST_4_WEEKS = "Last 4 Weeks";
    public static final String LAST_MONTH = "Last Month";
    public static final String LAST_3_MONTH = "Last 3 Month";
    public static final String LAST_QUARTER = "Last Quarter";
    public static final String LAST_12_MONTH = "Last 12 Month";
    public static final String LAST_YEAR = "Last Year";
    private UNIT unit;
    private String title;

    public Timespan(long start, long end, UNIT unit, String title) {
        this.start = start;
        this.end = end;
        this.unit = unit;
        this.title = title;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public UNIT getUnit() {
        return this.unit;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return "Timespan{ " + new Date(this.start) + " - " + new Date(this.end) + " }";
    }

    public static Timespan last24Hours() {
        Calendar cal = Calendar.getInstance();
        long t1 = cal.getTimeInMillis();
        cal.add(6, -1);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, UNIT.HOUR, LAST_24_HOURS);
    }

    public static Timespan lastDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -1);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        long t1 = cal.getTimeInMillis();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, UNIT.HOUR, LAST_DAY);
    }

    public static Timespan last7Days() {
        Calendar cal = Calendar.getInstance();
        long t1 = cal.getTimeInMillis();
        cal.add(6, -7);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, UNIT.DAY, LAST_7_DAYS);
    }

    public static Timespan lastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.add(3, -1);
        cal.set(7, cal.getActualMaximum(7));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        long t1 = cal.getTimeInMillis();
        cal.set(7, cal.getActualMinimum(7));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, UNIT.DAY, LAST_WEEK);
    }

    public static Timespan last4Weeks() {
        Calendar cal = Calendar.getInstance();
        long t1 = cal.getTimeInMillis();
        cal.add(3, -4);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, UNIT.DAY, LAST_4_WEEKS);
    }

    public static Timespan lastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        long t1 = cal.getTimeInMillis();
        cal.set(5, cal.getActualMinimum(5));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, UNIT.DAY, LAST_MONTH);
    }

    public static Timespan last3Month() {
        Calendar cal = Calendar.getInstance();
        long t1 = cal.getTimeInMillis();
        cal.add(2, -3);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, UNIT.WEEK, LAST_3_MONTH);
    }

    public static Timespan lastQuarter() {
        Calendar cal = Calendar.getInstance();
        long currentMonth = cal.get(2);
        if (currentMonth >= 1L && currentMonth <= 3L) {
            cal.set(2, 2);
        } else if (currentMonth >= 4L && currentMonth <= 6L) {
            cal.set(2, 5);
        } else if (currentMonth >= 7L && currentMonth <= 9L) {
            cal.set(2, 8);
        } else {
            cal.set(2, 11);
        }
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        long t1 = cal.getTimeInMillis();
        cal.add(2, -2);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, UNIT.WEEK, LAST_QUARTER);
    }

    public static Timespan last12Month() {
        Calendar cal = Calendar.getInstance();
        long t1 = cal.getTimeInMillis();
        cal.add(1, -1);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, UNIT.MONTH, LAST_12_MONTH);
    }

    public static Timespan lastYear() {
        Calendar cal = Calendar.getInstance();
        cal.add(1, -1);
        cal.set(2, 11);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        long t1 = cal.getTimeInMillis();
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        long t0 = cal.getTimeInMillis();
        return new Timespan(t0, t1, UNIT.MONTH, LAST_YEAR);
    }

    public static Timespan fromValue(String value) {
        Timespan t = null;
        if (LAST_24_HOURS.equals(value)) {
            t = Timespan.last24Hours();
        } else if (LAST_DAY.equals(value)) {
            t = Timespan.lastDay();
        } else if (LAST_7_DAYS.equals(value)) {
            t = Timespan.last7Days();
        } else if (LAST_WEEK.equals(value)) {
            t = Timespan.lastWeek();
        } else if (LAST_4_WEEKS.equals(value)) {
            t = Timespan.last4Weeks();
        } else if (LAST_MONTH.equals(value)) {
            t = Timespan.lastMonth();
        } else if (LAST_3_MONTH.equals(value)) {
            t = Timespan.last3Month();
        } else if (LAST_QUARTER.equals(value)) {
            t = Timespan.lastQuarter();
        } else if (LAST_12_MONTH.equals(value)) {
            t = Timespan.last12Month();
        } else if (LAST_YEAR.equals(value)) {
            t = Timespan.lastYear();
        }
        if (null == t) {
            throw new IllegalArgumentException("Unknown value: " + value);
        }
        return t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UNIT {
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }
}

