/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.model.metric;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.bpm.monitor.model.bpaf.Event;
import org.jboss.bpm.monitor.model.metric.Average;

public class Metrics {
    public static Average getInstanceAverage(List<Event> events) {
        assert (events.size() > 0) : "Empty event list";
        assert (events.size() % 2 == 0) : "Parity error: " + events.size() + " events. Every event should have closing counterpart!";
        Average stat = new Average(events.get(0).getProcessDefinitionID());
        HashMap<String, Long> duration = new HashMap<String, Long>(events.size() / 2);
        for (Event e : events) {
            String processInstance = e.getProcessInstanceID();
            Long l0 = (Long)duration.get(processInstance);
            if (l0 != null) {
                long l1 = e.getTimestamp();
                if (l0 < l1) {
                    duration.put(processInstance, l1 - l0);
                    continue;
                }
                duration.put(processInstance, l0 - l1);
                continue;
            }
            duration.put(processInstance, e.getTimestamp());
        }
        long sum = 0L;
        for (String processInstance : duration.keySet()) {
            long l3 = (Long)duration.get(processInstance);
            if (stat.getMin() == -1L) {
                stat.setMin(l3);
            } else if (l3 < stat.getMin()) {
                stat.setMin(l3);
            } else if (l3 > stat.getMax()) {
                stat.setMax(l3);
            }
            sum += l3;
        }
        stat.setAvg(sum / (long)duration.entrySet().size());
        return stat;
    }

    public static Average getActivityAverage(List<Event> events, String activityDefinition) {
        assert (events.size() > 0) : "Empty event list";
        assert (events.size() % 2 == 0) : "Parity error: " + events.size() + " events. Every event should have closing counterpart!";
        Average stat = new Average(activityDefinition);
        HashMap<String, Long> in = new HashMap<String, Long>(events.size() / 2);
        ArrayList<Long> out = new ArrayList<Long>();
        for (Event e : events) {
            String activity = e.getActivityDefinitionID();
            if (!activity.equals(activityDefinition)) continue;
            Long l0 = (Long)in.get(activity);
            if (l0 != null) {
                long l1 = e.getTimestamp();
                if (l0 < l1) {
                    out.add(l1 - l0);
                    continue;
                }
                out.add(l0 - l1);
                continue;
            }
            in.put(activity, e.getTimestamp());
        }
        long sum = 0L;
        for (Long l3 : out) {
            if (stat.getMin() == -1L) {
                stat.setMin(l3);
                stat.setMax(l3);
            } else if (l3 < stat.getMin()) {
                stat.setMin(l3);
            } else if (l3 > stat.getMax()) {
                stat.setMax(l3);
            }
            sum += l3.longValue();
        }
        stat.setAvg(sum / (long)out.size());
        return stat;
    }
}

