/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.api.config;

//$Id: ConfigurationProvider.java 3247 2008-12-06 16:33:05Z thomas.diesler@jboss.com $

import java.io.InputStream;
import java.net.URL;

import org.jboss.bpm.api.service.ProcessEngine;

/**
 * The ConfigurationProvider provides a ProcessEngine
 * 
 * @author thomas.diesler@jboss.com
 * @since 18-Jun-2008
 */
public interface ConfigurationProvider
{
  /**
   * Get a ProcessEngine from this ConfigurationProvider
   * @return The configured instance of a process engine
   */
  ProcessEngine getProcessEngine();
  
  /**
   * Get a ProcessEngine with a given name from this ConfigurationProvider
   * @return The configured instance of a process engine
   */
  ProcessEngine getProcessEngine(String name);
  
  /**
   * Configure this provider from the given URL
   */
  void configure(URL urlConfig);
  
  /**
   * Configure this provider from the resource
   */
  void configure(String resourceConfig);
  
  /**
   * Configure this provider from the resource
   */
  void configure(InputStream streamConfig);
}