/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.api.model;

//$Id: ProcessStructure.java 3107 2008-11-27 08:27:37Z thomas.diesler@jboss.com $

import java.util.List;

/**
 * A ProcessStructure defines the structure of a Process 
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface ProcessStructure extends AbstractElement
{
  /**
   * Get the unique name.
   */
  String getName();

  /**
   * Get the list of nodes
   */
  List<Node> getNodes();

  /**
   * Get a list of nodes of a given type.
   */
  <T extends Node> List<T> getNodes(Class<T> clazz);

  /**
   * Get a node of a given type and name
   */
  <T extends Node> T getNode(Class<T> clazz, String name);

  /**
   * Get a node by name.
   * @return null if not found
   */
  Node getNode(String name);
}