/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.api.service;

//$Id: MessageBuilderService.java 3484 2008-12-20 14:32:41Z thomas.diesler@jboss.com $

import org.jboss.bpm.api.config.Configuration;
import org.jboss.bpm.api.model.Message;
import org.jboss.bpm.api.model.builder.MessageBuilder;
import org.jboss.bpm.api.service.internal.AbstractService;

/**
 * The MessageBuilder can be used to build a {@link Message} dynamically.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public abstract class MessageBuilderService extends AbstractService
{
  /**
   * Locate the default MessageBuilder
   */
  public static MessageBuilder locateMessageBuilder()
  {
    ProcessEngine engine = Configuration.getProcessEngine();
    MessageBuilderService builderService = engine.getService(MessageBuilderService.class);
    return builderService.getMessageBuilder();
  }
  
  /**
   * Get the MessageBuilder
   */
  public abstract MessageBuilder getMessageBuilder();
}