/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.api.service;

//$Id: ProcessDefinitionService.java 3213 2008-12-05 09:26:04Z thomas.diesler@jboss.com $

import java.io.IOException;
import java.net.URL;
import java.util.Set;

import javax.management.ObjectName;

import org.jboss.bpm.api.model.ProcessDefinition;

/**
 * The ProcessDefinitionService is the entry point to create, find and otherwise manage process definitions.
 * 
 * @author thomas.diesler@jboss.com
 * @since 25-Sep-2008
 */
public interface ProcessDefinitionService
{
  /**
   * Create a ProcessDefinition from a XML string in one of the supported formats
   */
  ProcessDefinition parseProcessDefinition(String pXML);

  /**
   * Create a ProcessDefinition from an URL to a XML descritor in one of the supported formats
   */
  ProcessDefinition parseProcessDefinition(URL pURL) throws IOException;
  
  /**
   * Register a ProcessDefinition.
   * @return An implementation may return a proxied version of the given ProcessDefinition   
   */
  ProcessDefinition registerProcessDefinition(ProcessDefinition procDef);

  /**
   * Unregister a ProcessDefinition.
   */
  boolean unregisterProcessDefinition(ObjectName procDefID);

  /**
   * Get a ProcessDefinition for a given id
   */
  ProcessDefinition getProcessDefinition(ObjectName procDefID);

  /**
   * Get the set of registered ProcessDefinition names
   */
  Set<ObjectName> getProcessDefinitions();
}