/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.api.service;

//$Id: ProcessInstanceService.java 3247 2008-12-06 16:33:05Z thomas.diesler@jboss.com $

import java.util.Set;

import javax.management.ObjectName;

import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.api.model.ProcessInstance.ProcessStatus;

/**
 * The ProcessInstanceService is the entry point to create, find and otherwise manage processe instances.
 * 
 * @author thomas.diesler@jboss.com
 * @since 25-Sep-2008
 */
public interface ProcessInstanceService
{

  /**
   * Register a ProcessInstance.
   * @return An implementation may return a proxied version of the given Process   
   */
  ProcessInstance registerInstance(ProcessInstance proc);

  /**
   * Unregister a ProcessInstance.
   */
  boolean unregisterInstance(ObjectName procID);

  /**
   * Get a ProcessInstance for a given id
   */
  ProcessInstance getInstance(ObjectName procID);

  /**
   * Get the set of registered ProcessInstances
   */
  Set<ObjectName> getInstance();

  /**
   * Get the set of ProcessInstance for a given ProcessDefinition
   * 
   * @param procDefID The process definition id
   * @param status The optional process status
   * @return An empty set if the process cannot be found
   */
  Set<ObjectName> getInstance(ObjectName procDefID, ProcessStatus status);

}