/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model;

import java.io.Serializable;

import org.jboss.bpm.api.model.Property;




//$Id: Assignment.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

/**
 * An Assignment, which is used in the definition of attributes for Process,
 * Activity, Event, Gateway, and Gate.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface Assignment extends Serializable
{
  public enum AssignTime
  {
    Start, End
  }

  /**
   * The target for the Assignment MUST be a Property of the Process or the activity
   * itself.
   */
  Property getTo();
  
  /**
   * The Expression MUST be made up of a combination of Values, Properties, and
   * Attributes, which are separated by operators such as add or multiply. The expression
   * language is defined in the ExpressionLanguage attribute of the Business Process
   * Diagram
   */
  Expression getFrom();

  /**
   * An Assignment MAY have a AssignTime setting. If the Object is an activity (Task,
   * Sub-Process, or Process), then the Assignment MUST have an AssignTime.
   * A value of Start means that the assignment SHALL occur at the start of the activity.
   * This can be used to assign the higher-level (global) Properties of the Process to the
   * (local) Properties of the activity as an input to the activity.
   * A value of End means that the assignment SHALL occur at the end of the activity.
   * This can be used to assign the (local) Properties of the activity to the higher-level
   * (global) Properties of the Process as an output to the activity.
   */
  AssignTime getAssignTime();
}
