/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model;

import org.jboss.bpm.api.model.Node;


//$Id: $


/**
 * An Event is something that “happens” during the course of a business process. 
 * <p/>
 * These Events affect the flow of the Process and usually have a cause or an impact.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface Event extends Node
{
  /**
   * Defines the type of an {@link Event}
   */
  enum EventType
  {
    Start, End, Intermediate 
  };
  
  /**
   * Defines the type of event detail
   */
  enum EventDetailType
  {
    None, Message, Error, Cancel, Compensation, Link, Multiple, Timer, Rule, Signal, Terminate 
  }
  
  /**
   * Get the type of this event
   */
  EventType getEventType();
}