/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model;

//$Id: Gate.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

import java.util.List;


/**
 * There MAY be zero or more Gates (except where noted below). Zero Gates are
 * allowed if the Gateway is last object in a Process flow and there are no Start or
 * End Events for the Process. If there are zero or only one incoming Sequence
 * Flow, then there MUST be at least two Gates.
 * 
 * For Exclusive Data-Based Gateways
 * When two Gates are required, one of them MAY be the DefaultGate.
 * 
 * For Exclusive Event-Based Gateways
 * There MUST be two or more Gates. (Note that this type of Gateway does not act
 * only as a Merge--it is always a Decision, at least.)
 * 
 * For Inclusive Gateways
 * When two Gates are required, one of them MAY be the DefaultGate.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface Gate 
{
  /**
   * Each Gate MUST have an associated (outgoing) Sequence Flow. 
   * 
   * For Exclusive Event-Based, Complex, and Parallel Gateways:
   * The Sequence Flow MUST have its Condition attribute set to None (there is not an
   * evaluation of a condition expression).
   * 
   * For Exclusive Data-Based, and Inclusive Gateways:
   * The Sequence Flow MUST have its Condition attribute set to Expression and
   * MUST have a valid ConditionExpression. The ConditionExpression MUST be
   * unique for all the Gates within the Gateway. If there is only one Gate (i.e., the
   * Gateway is acting only as a Merge), then Sequence Flow MUST have its Condition
   * set to None.
   * 
   * For DefaultGates:
   * The Sequence Flow MUST have its Condition attribute set to Otherwise
   */
  SequenceFlow getOutgoingSequenceFlow();

  /**
   * One or more assignment expressions MAY be made for each Gate. The
   * Assignment SHALL be performed when the Gate is selected.
   */
  List<Assignment> getAssignments();
}
