/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model;



//$Id: InclusiveGateway.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

/**
 * This Decision represents a branching point where Alternatives are based on conditional expressions contained within
 * outgoing Sequence Flow. However, in this case, the True evaluation of one condition expression does not exclude the
 * evaluation of other condition expressions. All Sequence Flow with a True evaluation will be traversed by a Token. In
 * some sense it’s like a grouping of related independent Binary (Yes/No) Decisions--and can be modeled that way. Since
 * each path is independent, all combinations of the paths may be taken, from zero to all. However, it should be
 * designed so that at least one path is taken.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface InclusiveGateway extends Gateway
{
}