/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model;

//$Id: NodeExt.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

import java.util.List;

import org.jboss.bpm.api.model.Node;
import org.jboss.bpm.api.model.PropertySupport;
import org.jboss.bpm.incubator.runtime.ExecutionHandler;
import org.jboss.bpm.incubator.runtime.FlowHandler;
import org.jboss.bpm.incubator.runtime.SignalHandler;

/**
 * A Node is an abstract element with a name and an associated process
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface NodeExt extends Node, PropertySupport
{
  /**
   * One or more assignment expressions MAY be made for the object. 
   * The Assignment SHALL be performed as defined by the AssignTime attribute.
   */
  List<Assignment> getAssignments();
  
  /** Get the associated Group */
  Group getGroupRef();
  
  /** 
   * Get the associated ExecutionHandler 
   */
  ExecutionHandler getExecutionHandler();

  /** 
   * Get the associated SignalHandler 
   */
  SignalHandler getSignalHandler();

  /** 
   * Get the associated FlowHandler 
   */
  FlowHandler getFlowHandler();
}