/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model;

//$Id: TaskExt.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

import java.util.List;



/**
 * A Task is an Atomic Activity that is included within a Process.
 * 
 * A Task is used when the work in the Process is not broken down to a finer level of Process Model detail. Generally, an end-user and/or an application are used to
 * perform the Task when it is executed.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface TaskExt extends Task, NodeExt
{
  /**
   * The InputSets attribute defines the data requirements for input to the Activity.
   * Zero or more InputSets MAY be defined. Each Input set is sufficient to allow the
   * Activity to be performed (if it has first been instantiated by the appropriate signal
   * arriving from an incoming Sequence Flow)
   */
  List<InputSet> getInputSets();
  
  /**
   * The OutputSets attribute defines the data requirements for output from the
   * activity. Zero or more OutputSets MAY be defined. At the completion of the
   * activity, only one of the OutputSets may be produced--It is up to the
   * implementation of the activity to determine which set will be produced. However,
   * the IORules attribute MAY indicate a relationship between an OutputSet and an
   * InputSet that started the activity.
   */
  List<OutputSet> getOutputSets();
  
  /**
   * The IORules attribute is a collection of expressions, each of which specifies the
   * required relationship between one input and one output. That is, if the activity is
   * instantiated with a specified input, that activity shall complete with the specified
   * output.
   */
  List<Expression> getIORules();
}