/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model.builder;

//$Id: ProcessBuilder.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

import org.jboss.bpm.api.model.ProcessDefinition;
import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.incubator.model.Gateway.GatewayType;
import org.jboss.bpm.incubator.model.Task.TaskType;

/**
 * The ProcessBuilder can be used to build a {@link ProcessInstance} dynamically.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface ProcessBuilder
{
  /**
   * Add a {@link ProcessInstance} with a given name
   */
  ProcessBuilder addProcess(String name);

  /**
   * Get the {@link ProcessDefinition}. 
   * <p/> 
   * This is the final call to the ProcessBuilder after all elements have been added.
   */
  ProcessDefinition getProcessDefinition();

  /**
   * Add a SequenceFlow with a given name
   */
  ProcessBuilder addSequenceFlow(String targetName);

  /**
   * Add a SartEvent with a given name
   */
  ProcessBuilder addStartEvent(String name);

  /**
   * Add an EndEvent with a given name
   */
  ProcessBuilder addEndEvent(String name);

  /**
   * Add a Task of {@link TaskType} NONE with a given name
   */
  ProcessBuilder addTask(String name);

  /**
   * Add a Task of {@link TaskType} with a given name
   */
  ProcessBuilder addTask(String name, TaskType type);

  /**
   * Add a Gateway with a given name
   */
  GatewayBuilder addGateway(String name, GatewayType type);
}