/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.incubator.model.builder;

//$Id: ProcessBuilderExt.java 3449 2008-12-19 17:39:28Z thomas.diesler@jboss.com $

import org.jboss.bpm.api.model.Message;
import org.jboss.bpm.api.model.Node;
import org.jboss.bpm.api.model.ProcessInstance;
import org.jboss.bpm.api.model.Property;
import org.jboss.bpm.api.model.builder.MessageBuilder;
import org.jboss.bpm.incubator.model.Assignment.AssignTime;
import org.jboss.bpm.incubator.model.Event.EventDetailType;
import org.jboss.bpm.incubator.model.Expression.ExpressionLanguage;
import org.jboss.bpm.incubator.model.Gateway.GatewayType;
import org.jboss.bpm.incubator.model.Group.GroupType;
import org.jboss.bpm.incubator.model.Task.TaskType;
import org.jboss.bpm.incubator.runtime.ExecutionHandler;
import org.jboss.bpm.incubator.runtime.FlowHandler;
import org.jboss.bpm.incubator.runtime.SignalHandler;

/**
 * The ProcessBuilder can be used to build a {@link ProcessInstance} dynamically.
 * 
 * @author thomas.diesler@jboss.com
 * @since 08-Jul-2008
 */
public interface ProcessBuilderExt extends ProcessBuilder
{
  /**
   * Add a SartEvent with a given name
   */
  EventBuilder addStartEventExt(String name);

  /**
   * Add a SartEvent with a given name and ResultType
   */
  EventBuilder addStartEventExt(String name, EventDetailType ResultType);

  /**
   * Add an IntermediateEvent with a given name
   */
  ProcessBuilderExt addEventExt(String name);

  /**
   * Add an EndEvent with a given name
   */
  EventBuilder addEndEventExt(String name);

  /**
   * Add an EndEvent with a given name and ResultType
   */
  EventBuilder addEndEventExt(String name, EventDetailType resultType);

  /**
   * Add a Task of {@link TaskType} NONE with a given name
   */
  TaskBuilder addTaskExt(String name);

  /**
   * Add a Task of {@link TaskType} with a given name
   */
  TaskBuilder addTaskExt(String name, TaskType type);

  /**
   * Add a Gateway with a given name
   */
  GatewayBuilder addGateway(String name, GatewayType type);
  
  /**
   * Add a {@link Message} with a given name.
   */
  MessageBuilder addProcessMessage(String name);
  
  /**
   * Add a {@link Property} to the process
   */
  ProcessBuilderExt addProcessProperty(String name, String value);
  
  /**
   * Add a {@link Property} to the current node
   */
  ProcessBuilderExt addNodeProperty(String name, String value);
  
  /**
   * Add an Assignment to the Process.
   */
  ProcessBuilderExt addProcessAssignment(AssignTime time, ExpressionLanguage lang, String fromExpr, String toProp);
  
  /**
   * Add an Assignment to the current {@link Node}.
   */
  ProcessBuilderExt addNodeAssignment(AssignTime time, ExpressionLanguage lang, String fromExpr, String toProp);
  
  /**
   * Add an {@link ExecutionHandler} with a given Class
   */
  <T extends ExecutionHandler> ProcessBuilderExt addExecutionHandler(Class<T> clazz);

  /**
   * Add an {@link FlowHandler} with a given Class
   */
  <T extends FlowHandler> ProcessBuilderExt addFlowHandler(Class<T> clazz);

  /**
   * Add an {@link SignalHandler} with a given Class
   */
  <T extends SignalHandler> ProcessBuilderExt addSignalHandler(Class<T> clazz);

  /**
   * Add a group reference for the current node
   */
  ProcessBuilderExt addGroupRef(String name);
  
  /**
   * Add a Process group
   */
  GroupBuilder addGroup(GroupType type, String name);
}