/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.api.service.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.bpm.api.model.ProcessDefinition;
import org.jboss.bpm.api.service.DialectHandler;
import org.jboss.bpm.api.service.DialectHandlerService;
import org.jboss.bpm.api.service.ProcessDefinitionService;
import org.jboss.bpm.api.service.internal.AbstractService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractProcessDefinitionService
extends AbstractService
implements ProcessDefinitionService {
    static final Logger log = LoggerFactory.getLogger(AbstractProcessDefinitionService.class);

    protected AbstractProcessDefinitionService() {
    }

    public final ProcessDefinition parseProcessDefinition(String pXML) {
        URI nsURI = this.getNamespaceURI(new ByteArrayInputStream(pXML.getBytes()));
        DialectHandlerService dhService = this.getProcessEngine().getService(DialectHandlerService.class);
        DialectHandler dialectHandler = dhService.getDialectHandler(nsURI);
        if (dialectHandler == null) {
            throw new IllegalStateException("Cannot obtain DialectHandler for: " + nsURI);
        }
        ProcessDefinition procDef = dialectHandler.parseProcessDefinition(pXML);
        return procDef;
    }

    public final ProcessDefinition parseProcessDefinition(URL pURL) throws IOException {
        URI nsURI = this.getNamespaceURI(pURL.openStream());
        DialectHandlerService dhService = this.getProcessEngine().getService(DialectHandlerService.class);
        DialectHandler dialectHandler = dhService.getDialectHandler(nsURI);
        if (dialectHandler == null) {
            throw new IllegalStateException("Cannot obtain DialectHandler for: " + nsURI);
        }
        ProcessDefinition procDef = dialectHandler.parseProcessDefinition(pURL);
        return procDef;
    }

    private URI getNamespaceURI(InputStream procXML) {
        Document doc;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(procXML);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot parse process descriptor", ex);
        }
        Element root = doc.getDocumentElement();
        String nsURI = root.getNamespaceURI();
        if (nsURI == null) {
            throw new IllegalStateException("Cannot get namespace URI from root element");
        }
        return URI.create(nsURI);
    }
}

