/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.api.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.jboss.bpm.api.config.Configuration;
import org.jboss.bpm.api.config.ConfigurationProvider;
import org.jboss.bpm.api.model.ObjectNameFactory;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.test.APITestHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APITestCase
extends TestCase {
    final Logger log = LoggerFactory.getLogger(APITestCase.class);
    private APITestHelper delegate = new APITestHelper();
    private static Map<String, ProcessEngine> engineRegistry = new HashMap<String, ProcessEngine>();

    protected void setUp() throws Exception {
        this.log.debug("### START " + this.getLongName());
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.log.debug("### END " + this.getLongName());
    }

    protected String getShortName() {
        String shortName = ((Object)((Object)this)).getClass().getName();
        shortName = shortName.substring(shortName.lastIndexOf(".") + 1);
        return shortName;
    }

    protected String getLongName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    public ObjectName getTestID() {
        String shortName = this.getShortName();
        shortName = shortName.replace("DescriptorTest", "Test");
        shortName = shortName.replace("MarshallerTest", "Test");
        return ObjectNameFactory.create("jboss.jbpm", "test", shortName);
    }

    protected String getDialect() {
        String propName = "bpm.dialect";
        String dialect = System.getProperty(propName);
        if (dialect == null) {
            throw new IllegalStateException("Cannot obtain dialect from system property: " + propName);
        }
        return dialect;
    }

    protected URI getDialectURI() {
        String dialect = System.getProperty("bpm.dialect.uri");
        return URI.create(dialect);
    }

    protected ProcessEngine getProcessEngine() {
        String dialect = this.getDialect();
        ProcessEngine engine = engineRegistry.get(dialect);
        if (engine == null) {
            String cfgResource;
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            URL cfgURL = ctxLoader.getResource(cfgResource = "bpm-spec-" + dialect + "-beans.xml");
            if (cfgURL == null) {
                throw new IllegalStateException("Cannot obtain resource: " + cfgResource);
            }
            ConfigurationProvider provider = Configuration.getConfigurationProvider();
            provider.configure(cfgURL);
            engine = provider.getProcessEngine();
            engineRegistry.put(dialect, engine);
        }
        return engine;
    }

    protected URL getResourceURL(String resource) {
        return this.delegate.getResourceURL(resource);
    }

    protected File getResourceFile(String resource) {
        return this.delegate.getResourceFile(resource);
    }

    public File getTestArchiveFile(String archive) {
        return this.delegate.getTestArchiveFile(archive);
    }

    public URL getTestArchiveURL(String archive) throws MalformedURLException {
        return this.delegate.getTestArchiveFile(archive).toURI().toURL();
    }
}

