/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.api.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.bpm.api.ProcessEngineException;
import org.jboss.bpm.api.model.Message;
import org.jboss.bpm.api.model.MessageListener;
import org.jboss.bpm.api.model.ProcessDefinition;
import org.jboss.bpm.api.model.Signal;
import org.jboss.bpm.api.model.SignalListener;
import org.jboss.bpm.api.model.builder.SignalBuilder;
import org.jboss.bpm.api.service.DialectHandler;
import org.jboss.bpm.api.service.DialectHandlerService;
import org.jboss.bpm.api.service.MessageService;
import org.jboss.bpm.api.service.ProcessDefinitionService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.api.service.SignalBuilderService;
import org.jboss.bpm.api.service.SignalService;
import org.jboss.bpm.api.test.APITestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTSTestCase
extends APITestCase {
    private static final Logger log = LoggerFactory.getLogger(CTSTestCase.class);
    private SignalListener signalListener;
    private List<Signal> signals = new ArrayList<Signal>();
    private MessageListener messageListener;
    private List<Message> messages = new ArrayList<Message>();
    private ProcessDefinition procDef;

    protected ProcessDefinition unregisterOnTearDown(ProcessDefinition procDef) {
        this.procDef = procDef;
        ProcessDefinitionService pdService = this.getProcessEngine().getService(ProcessDefinitionService.class);
        return pdService.registerProcessDefinition(procDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setUp() throws Exception {
        MessageService msgService;
        super.setUp();
        ProcessEngine engine = this.getProcessEngine();
        SignalService sigService = engine.getService(SignalService.class);
        if (sigService != null) {
            this.clearAllSignalListeners(sigService);
            sigService.addSignalListener(this.getSignalListener());
            List<Signal> list = this.signals;
            synchronized (list) {
                this.signals.clear();
            }
        }
        if ((msgService = engine.getService(MessageService.class)) != null) {
            this.clearAllMessageListeners(msgService);
            msgService.addMessageListener(this.getMessageListener());
        }
    }

    @Override
    protected void tearDown() throws Exception {
        MessageService msgService;
        SignalService sigService;
        Set<ObjectName> procs;
        ProcessEngine engine = this.getProcessEngine();
        ProcessDefinitionService procDefService = engine.getService(ProcessDefinitionService.class);
        if (this.procDef != null) {
            procDefService.unregisterProcessDefinition(this.procDef.getKey());
            this.procDef = null;
        }
        if ((procs = procDefService.getProcessDefinitions()).size() > 0) {
            String logMsg = "Registered processes on tear down of " + this.getName() + ": " + procs;
            System.out.println(logMsg);
            log.error(logMsg);
        }
        if ((sigService = engine.getService(SignalService.class)) != null) {
            sigService.removeSignalListener(this.getSignalListener());
            Set<SignalListener> sigListeners = sigService.getSignalListeners();
            if (sigListeners.size() > 0) {
                String logMsg = "Registered signal listeners on tear down of " + this.getName() + ": " + sigListeners;
                System.out.println(logMsg);
                log.error(logMsg);
            }
        }
        if ((msgService = engine.getService(MessageService.class)) != null) {
            msgService.removeMessageListener(this.getTestID());
            Set<MessageListener> msgListeners = msgService.getMessageListeners();
            if (msgListeners.size() > 0) {
                String logMsg = "Registered message listeners on tear down of " + this.getName() + ": " + msgListeners;
                System.out.println(logMsg);
                log.error(logMsg);
            }
        }
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Signal> getSignals() {
        List<Signal> list = this.signals;
        synchronized (list) {
            return Collections.unmodifiableList(this.signals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getMessages() {
        List<Message> list = this.messages;
        synchronized (list) {
            return Collections.unmodifiableList(this.messages);
        }
    }

    protected Signal newSignal(ObjectName fromRef, Signal.SignalType signalType, String message) {
        SignalBuilder sigBuilder = this.getProcessEngine().getService(SignalBuilderService.class).getSignalBuilder();
        return sigBuilder.newSignal(signalType, fromRef, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Signal> getSignals(Signal.SignalType type) {
        List<Signal> list = this.signals;
        synchronized (list) {
            ArrayList<Signal> retSignals = new ArrayList<Signal>();
            for (Signal sig : this.signals) {
                if (sig.getSignalType() != type) continue;
                retSignals.add(sig);
            }
            return Collections.unmodifiableList(retSignals);
        }
    }

    private void clearAllSignalListeners(SignalService sigService) {
        Set<SignalListener> sigListeners = sigService.getSignalListeners();
        for (SignalListener sigListener : sigListeners) {
            sigService.removeSignalListener(sigListener);
        }
    }

    private void clearAllMessageListeners(MessageService msgService) {
        Set<MessageListener> msgListeners = msgService.getMessageListeners();
        for (MessageListener msgListener : msgListeners) {
            msgService.removeMessageListener(msgListener.getKey());
        }
    }

    public SignalListener getSignalListener() {
        if (this.signalListener == null) {
            this.signalListener = new SignalListener(){

                public boolean acceptSignal(Signal signal) {
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void catchSignal(Signal signal) {
                    List list = CTSTestCase.this.signals;
                    synchronized (list) {
                        CTSTestCase.this.signals.add(signal);
                    }
                }

                public String toString() {
                    return "SignalListener[" + CTSTestCase.this.getShortName() + "]";
                }
            };
        }
        return this.signalListener;
    }

    public MessageListener getMessageListener() {
        if (this.messageListener == null) {
            this.messageListener = new MessageListener(){

                public ObjectName getKey() {
                    return CTSTestCase.this.getTestID();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void catchMessage(Message message) {
                    List list = CTSTestCase.this.messages;
                    synchronized (list) {
                        log.debug("catchMessage: " + message);
                        CTSTestCase.this.messages.add(message);
                    }
                }
            };
        }
        return this.messageListener;
    }

    protected String marshallProcess(ProcessDefinition procDef, Writer out) {
        try {
            if (out == null) {
                File file = new File("target/" + this.getName() + "-" + this.getDialect() + ".xml");
                out = new FileWriter(file);
                System.out.println("Marshall process to: " + file.getCanonicalPath());
            }
            String procXML = this.marshallProcess(procDef);
            out.write(procXML);
            out.close();
            return procXML;
        }
        catch (IOException ex) {
            throw new ProcessEngineException("Cannot marshall process", ex);
        }
    }

    public String marshallProcess(ProcessDefinition procDef) throws IOException {
        DialectHandlerService dhService = this.getProcessEngine().getService(DialectHandlerService.class);
        DialectHandler dialectHandler = dhService.getDialectHandler(this.getDialectURI());
        StringWriter strwr = new StringWriter();
        dialectHandler.marshallProcessDefinition(procDef, strwr);
        return strwr.toString();
    }
}

