/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.api.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import org.jboss.bpm.api.test.APITestSetup;
import org.jboss.bpm.api.test.IntegrationTestHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrationTestSetup
extends APITestSetup {
    private IntegrationTestHelper delegate = new IntegrationTestHelper();
    private String[] archives = new String[0];
    private ClassLoader originalClassLoader;

    public IntegrationTestSetup(Class<?> testClass, String archiveList) {
        super(testClass);
        this.getArchiveArray(archiveList);
    }

    public File getArchiveFile(String archive) {
        return this.delegate.getTestArchiveFile(archive);
    }

    public URL getArchiveURL(String archive) throws MalformedURLException {
        return this.delegate.getTestArchiveFile(archive).toURI().toURL();
    }

    public boolean isTargetJBoss500() {
        return this.delegate.isTargetJBoss500();
    }

    public boolean isTargetJBoss423() {
        return this.delegate.isTargetJBoss423();
    }

    public boolean isTargetJBoss422() {
        return this.delegate.isTargetJBoss422();
    }

    public MBeanServerConnection getServer() {
        return this.delegate.getServer();
    }

    private void getArchiveArray(String archiveList) {
        if (archiveList != null) {
            StringTokenizer st = new StringTokenizer(archiveList, ", ");
            this.archives = new String[st.countTokens()];
            for (int i = 0; i < this.archives.length; ++i) {
                this.archives[i] = st.nextToken();
            }
        }
    }

    @Override
    protected void setUp() throws Exception {
        ClassLoader parent;
        super.setUp();
        ArrayList<URL> clientJars = new ArrayList<URL>();
        for (int i = 0; i < this.archives.length; ++i) {
            String archive = this.archives[i];
            try {
                this.delegate.deploy(archive);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.delegate.undeploy(archive);
            }
            if (!archive.endsWith("-client.jar")) continue;
            URL archiveURL = this.getArchiveURL(archive);
            clientJars.add(archiveURL);
        }
        this.originalClassLoader = parent = Thread.currentThread().getContextClassLoader();
        if (!clientJars.isEmpty()) {
            URL[] urls = new URL[clientJars.size()];
            for (int i = 0; i < clientJars.size(); ++i) {
                urls[i] = (URL)clientJars.get(i);
            }
            URLClassLoader cl = new URLClassLoader(urls, parent);
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            for (int i = 0; i < this.archives.length; ++i) {
                String archive = this.archives[this.archives.length - i - 1];
                this.delegate.undeploy(archive);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
        super.tearDown();
    }
}

