/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.incubator.client;

import javax.management.ObjectName;
import org.jboss.bpm.api.model.Message;
import org.jboss.bpm.api.model.MessageListener;
import org.jboss.bpm.api.model.ObjectNameFactory;
import org.jboss.bpm.api.model.builder.MessageBuilder;
import org.jboss.bpm.api.runtime.Attachments;
import org.jboss.bpm.api.runtime.BasicAttachments;
import org.jboss.bpm.api.service.MessageBuilderService;
import org.jboss.bpm.api.service.MessageService;
import org.jboss.bpm.api.service.ProcessEngine;
import org.jboss.bpm.incubator.model.UserTask;

public abstract class UserTaskCallback {
    private MessageListener messageListener;

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public void attach(UserTask userTask) {
        userTask.setUserTaskCallback(this);
        this.messageListener = new CallbackMessageListener(userTask);
        ProcessEngine engine = userTask.getProcessDefinition().getProcessEngine();
        MessageService msgService = engine.getService(MessageService.class);
        msgService.addMessageListener(this.messageListener);
    }

    public void detach(UserTask userTask) {
        ProcessEngine engine = userTask.getProcessDefinition().getProcessEngine();
        MessageService msgService = engine.getService(MessageService.class);
        msgService.removeMessageListener(this.messageListener.getKey());
    }

    public abstract void callback(Attachments var1);

    class CallbackMessageListener
    implements MessageListener {
        private UserTask userTask;

        public CallbackMessageListener(UserTask userTask) {
            this.userTask = userTask;
        }

        public void catchMessage(Message msg) {
            BasicAttachments att = new BasicAttachments();
            for (String propName : msg.getPropertyNames()) {
                String value = msg.getProperty(propName).getValue();
                att.addAttachment(propName, (Object)value);
            }
            UserTaskCallback.this.callback(att);
            Message msgRef = this.userTask.getInMessageRef();
            MessageBuilder msgBuilder = MessageBuilderService.locateMessageBuilder();
            msgBuilder.newMessage(msgRef.getName());
            for (String propName : msgRef.getPropertyNames()) {
                Object value = att.getAttachment(propName);
                if (value == null) {
                    throw new IllegalStateException("Cannot obtain required property: " + propName);
                }
                msgBuilder.addProperty(propName, value);
            }
            Message resMessage = msgBuilder.getMessage();
            MessageService msgService = MessageService.locateMessageService();
            ObjectName procID = this.userTask.getProcessInstance().getKey();
            msgService.sendMessage(procID, this.userTask.getName(), resMessage);
        }

        public ObjectName getKey() {
            String oname = this.userTask.getKey().getCanonicalName();
            return ObjectNameFactory.create(oname + ",msgListener=UserTaskCallback");
        }
    }
}

