/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.integration.jboss42;

//$Id: PARDeployerInterceptorEJB3.java 3272 2008-12-08 14:38:05Z thomas.diesler@jboss.com $

import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.deployment.SubDeployerInterceptorSupport;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.util.MBeanProxy;

/**
 * A deployer service that manages BPM Process Deployments
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 08-Dec-2008
 */
public class PARDeployerInterceptorEJB3 extends SubDeployerInterceptorSupport implements PARDeployerInterceptorEJB3MBean
{
  // The main deployer
  private MainDeployerMBean mainDeployer;
  
  @Override
  protected final Object create(Invocation invocation, DeploymentInfo di) throws Throwable
  {
    Object retn = invokeNext(invocation);

    ProcessDeploymentHelper depHelper = new ProcessDeploymentHelper();
    depHelper.create(di);
    
    return retn;
  }

  @Override
  protected final Object destroy(Invocation invocation, DeploymentInfo di) throws Throwable
  {
    Object retn = invokeNext(invocation);

    ProcessDeploymentHelper depHelper = new ProcessDeploymentHelper();
    depHelper.destroy(di);
    
    return retn;
  }

  /**
   * Create the deployer service
   */
  protected void createService() throws Exception
  {
    mainDeployer = (MainDeployerMBean)MBeanProxy.get(MainDeployerMBean.class, MainDeployerMBean.OBJECT_NAME, server);
    super.attach();
  }

  /**
   *  Destroy the deployer service
   */
  protected void destroyService()
  {
    super.detach();
  }

  /**
   * Handle all process deployment exceptions. 
   * You can either simply log the problem and keep the EJB/WAR module alive or undeploy properly.
   */
  protected void handleStartupException(DeploymentInfo di, Throwable th)
  {
    log.error("Cannot startup process for: " + di.shortName, th);
    mainDeployer.undeploy(di);
  }

  /**
   * Handle all process deployment exceptions. 
   * You can either simply logs the problem and keep the EJB/WAR module alive or undeploy properly.
   */
  protected void handleShutdownException(String moduleName, Throwable th)
  {
    log.error("Cannot shutdown process for: " + moduleName, th);
  }
}