/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessDefinitionRefWrapper;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRefWrapper;
import org.jboss.bpm.console.server.gson.GsonFactory;
import org.jboss.bpm.console.server.integration.ManagementFactory;
import org.jboss.bpm.console.server.integration.ProcessManagement;
import org.jboss.bpm.console.server.plugin.FormAuthorityRef;
import org.jboss.bpm.console.server.plugin.FormDispatcherPlugin;
import org.jboss.bpm.console.server.plugin.GraphViewerPlugin;
import org.jboss.bpm.console.server.plugin.PluginMgr;
import org.jboss.bpm.console.server.plugin.ProcessActivityPlugin;
import org.jboss.bpm.console.server.util.Payload2XML;
import org.jboss.bpm.console.server.util.ProjectName;
import org.jboss.bpm.console.server.util.RsComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="process")
@RsComment(title="Process Management", description="Process related data.")
public class ProcessMgmtFacade {
    private static final Logger log = LoggerFactory.getLogger(ProcessMgmtFacade.class);
    private ProcessManagement processManagement;
    private GraphViewerPlugin graphViewerPlugin;
    private ProcessActivityPlugin activityPlugin;
    private FormDispatcherPlugin formPlugin;

    private FormDispatcherPlugin getFormDispatcherPlugin() {
        if (null == this.formPlugin) {
            this.formPlugin = (FormDispatcherPlugin)PluginMgr.load(FormDispatcherPlugin.class);
        }
        return this.formPlugin;
    }

    private ProcessManagement getProcessManagement() {
        if (null == this.processManagement) {
            ManagementFactory factory = ManagementFactory.newInstance();
            this.processManagement = factory.createProcessManagement();
            log.debug("Using ManagementFactory impl:" + factory.getClass().getName());
        }
        return this.processManagement;
    }

    private GraphViewerPlugin getGraphViewerPlugin() {
        if (this.graphViewerPlugin == null) {
            this.graphViewerPlugin = (GraphViewerPlugin)PluginMgr.load(GraphViewerPlugin.class);
        }
        return this.graphViewerPlugin;
    }

    private ProcessActivityPlugin getActivityPlugin() {
        if (this.activityPlugin == null) {
            this.activityPlugin = (ProcessActivityPlugin)PluginMgr.load(ProcessActivityPlugin.class);
        }
        return this.activityPlugin;
    }

    @GET
    @Path(value="definitions")
    @Produces(value={"application/json"})
    public Response getDefinitionsJSON() {
        List processDefinitions = this.getProcessManagement().getProcessDefinitions();
        return this.decorateProcessDefintions(processDefinitions);
    }

    private Response decorateProcessDefintions(List<ProcessDefinitionRef> processDefinitions) {
        GraphViewerPlugin graphViewer;
        FormDispatcherPlugin formPlugin = this.getFormDispatcherPlugin();
        if (formPlugin != null) {
            for (ProcessDefinitionRef def : processDefinitions) {
                URL processFormURL = formPlugin.getDispatchUrl(new FormAuthorityRef(def.getId(), FormAuthorityRef.Type.PROCESS));
                if (processFormURL == null) continue;
                def.setFormUrl(processFormURL.toExternalForm());
            }
        }
        if ((graphViewer = this.getGraphViewerPlugin()) != null) {
            for (ProcessDefinitionRef def : processDefinitions) {
                URL diagramUrl = graphViewer.getDiagramURL(def.getId());
                if (diagramUrl == null) continue;
                def.setDiagramUrl(diagramUrl.toExternalForm());
            }
        }
        ProcessDefinitionRefWrapper wrapper = new ProcessDefinitionRefWrapper(processDefinitions);
        return this.createJsonResponse((Object)wrapper);
    }

    @POST
    @Path(value="definition/{id}/remove")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response removeDefinitionsJSON(@PathParam(value="id") String definitionId) {
        ProcessDefinitionRefWrapper wrapper = new ProcessDefinitionRefWrapper(this.getProcessManagement().removeProcessDefinition(definitionId));
        return this.createJsonResponse((Object)wrapper);
    }

    @GET
    @Path(value="definition/{id}/instances")
    @Produces(value={"application/json"})
    public Response getInstancesJSON(@PathParam(value="id") String definitionId) {
        ProcessInstanceRefWrapper wrapper = new ProcessInstanceRefWrapper(this.getProcessManagement().getProcessInstances(definitionId));
        return this.createJsonResponse((Object)wrapper);
    }

    @POST
    @Path(value="definition/{id}/new_instance")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response newInstance(@PathParam(value="id") String definitionId) {
        ProcessInstanceRef instance = null;
        try {
            instance = this.getProcessManagement().newInstance(definitionId);
            return this.createJsonResponse((Object)instance);
        }
        catch (Throwable t) {
            throw new WebApplicationException(t, 500);
        }
    }

    @GET
    @Path(value="instance/{id}/dataset")
    @Produces(value={"text/xml"})
    public Response getInstanceData(@PathParam(value="id") String instanceId) {
        Map javaPayload = this.getProcessManagement().getInstanceData(instanceId);
        Payload2XML payload2XML = new Payload2XML();
        StringBuffer sb = payload2XML.convert(instanceId, javaPayload);
        return Response.ok((Object)sb.toString()).build();
    }

    @POST
    @Path(value="instance/{id}/state/{next}")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response changeState(@PathParam(value="id") String executionId, @PathParam(value="next") String next) {
        ProcessInstanceRef.STATE state = ProcessInstanceRef.STATE.valueOf((String)next);
        log.debug("Change instance (ID " + executionId + ") to state " + state);
        this.getProcessManagement().setProcessState(executionId, state);
        return Response.ok().type("application/json").build();
    }

    @POST
    @Path(value="instance/{id}/end/{result}")
    @Produces(value={"application/json"})
    public Response endInstance(@PathParam(value="id") String executionId, @PathParam(value="result") String resultValue) {
        ProcessInstanceRef.RESULT result = ProcessInstanceRef.RESULT.valueOf((String)resultValue);
        log.debug("Change instance (ID " + executionId + ") to state " + ProcessInstanceRef.STATE.ENDED);
        this.getProcessManagement().endInstance(executionId, result);
        return Response.ok().type("application/json").build();
    }

    @POST
    @Path(value="instance/{id}/delete")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response deleteInstance(@PathParam(value="id") String executionId) {
        log.debug("Delete instance (ID " + executionId + ")");
        this.getProcessManagement().deleteInstance(executionId);
        return Response.ok().type("application/json").build();
    }

    @GET
    @Path(value="instances/delete")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.RIFTSAW})
    public Response removeOldInstances(@QueryParam(value="status") String status, @QueryParam(value="started") String started, @QueryParam(value="last-active") String lastActive) {
        StringBuilder sbuilder = new StringBuilder();
        if (this.isNotNull(status)) {
            sbuilder.append("status=").append(status).append(" ");
        }
        if (this.isNotNull(started)) {
            sbuilder.append("started").append(started).append(" ");
        }
        if (this.isNotNull(lastActive)) {
            sbuilder.append("last-active").append(lastActive).append(" ");
        }
        long result = 0L;
        if (this.isNotNull(sbuilder.toString())) {
            try {
                result = this.getProcessManagement().deleteInstances(sbuilder.toString());
            }
            catch (Exception e) {
                return this.createJsonResponse((Object)("Error! " + e.getMessage()));
            }
        }
        return this.createJsonResponse((Object)(result + " process instances have been removed successfully."));
    }

    private boolean isNotNull(String val) {
        return val != null && !"".equals(val.trim());
    }

    @POST
    @Path(value="tokens/{id}/transition")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response signalExecution(@PathParam(value="id") String id, @QueryParam(value="signal") String signalName) {
        try {
            id = URLDecoder.decode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        log.debug("Signal token " + id + " -> " + signalName);
        if ("default transition".equals(signalName)) {
            signalName = null;
        }
        this.getProcessManagement().signalExecution(id, signalName);
        return Response.ok().type("application/json").build();
    }

    @POST
    @Path(value="tokens/{id}/transition/default")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response signalExecutionDefault(@PathParam(value="id") String id) {
        try {
            id = URLDecoder.decode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        log.debug("Signal token " + id);
        this.getProcessManagement().signalExecution(id, null);
        return Response.ok().type("application/json").build();
    }

    @GET
    @Path(value="definition/{id}/image")
    @Produces(value={"image/*"})
    public Response getProcessImage(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        GraphViewerPlugin plugin = this.getGraphViewerPlugin();
        if (plugin != null) {
            byte[] processImage = plugin.getProcessImage(id);
            if (processImage != null) {
                return Response.ok((Object)processImage).type("image/png").build();
            }
            return Response.status((int)404).build();
        }
        throw new RuntimeException(GraphViewerPlugin.class.getName() + " not available.");
    }

    @GET
    @Path(value="definition/{id}/image/{instance}")
    @Produces(value={"image/*"})
    public Response getProcessInstanceImage(@Context HttpServletRequest request, @PathParam(value="id") String id, @PathParam(value="instance") String instance) {
        ProcessActivityPlugin plugin = this.getActivityPlugin();
        if (plugin != null) {
            byte[] processImage = plugin.getProcessInstanceImage(id, instance);
            if (processImage != null) {
                return Response.ok((Object)processImage).type("image/png").build();
            }
            return Response.status((int)404).build();
        }
        throw new RuntimeException(ProcessActivityPlugin.class.getName() + " not available.");
    }

    @GET
    @Path(value="instance/{id}/activeNodeInfo")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response getActiveNodeInfo(@PathParam(value="id") String id) {
        GraphViewerPlugin plugin = this.getGraphViewerPlugin();
        if (plugin != null) {
            List info = plugin.getActiveNodeInfo(id);
            return this.createJsonResponse((Object)info);
        }
        throw new RuntimeException(GraphViewerPlugin.class.getName() + " not available.");
    }

    @GET
    @Path(value="definition/history/{id}/nodeInfo")
    @Produces(value={"application/json"})
    @RsComment(project={ProjectName.JBPM})
    public Response getNodeInfoForActivities(@PathParam(value="id") String id, @QueryParam(value="activity") String[] activities) {
        GraphViewerPlugin plugin = this.getGraphViewerPlugin();
        if (plugin != null) {
            List info = plugin.getNodeInfoForActivities(id, Arrays.asList(activities));
            return this.createJsonResponse((Object)info);
        }
        throw new RuntimeException(GraphViewerPlugin.class.getName() + " not available.");
    }

    private Response createJsonResponse(Object wrapper) {
        Gson gson = GsonFactory.createInstance();
        String json = gson.toJson(wrapper);
        return Response.ok((Object)json).type("application/json").build();
    }
}

