/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server.plugin;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.console.server.util.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginMgr {
    private static final Log log = LogFactory.getLog(PluginMgr.class);
    private static List<String> failedToResolve = new CopyOnWriteArrayList<String>();

    public static <T> T load(Class<T> type) {
        boolean failedBefore = failedToResolve.contains(type.getName());
        if (failedBefore) {
            return null;
        }
        Object pluginImpl = ServiceLoader.loadService(type.getName(), null);
        if (pluginImpl != null) {
            log.info((Object)("Successfully loaded plugin '" + type.getName() + "': " + pluginImpl.getClass()));
            return (T)pluginImpl;
        }
        failedToResolve.add(type.getName());
        return null;
    }
}

