/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.i18n.client.Dictionary;

/**
 * Initialize console config from host page (<code>Application.html</code>) variable:
 * <pre>
 *  var consoleConfig = {
 * consoleServerUrl: "http://localhost:8080/gwt-console-server",
 * reportServerUrl: "http://localhost:8080/report",
 * [...]
 * };
 * </pre>
 *
 * @author Heiko.Braun <heiko.braun@jboss.com>
 * @see com.google.gwt.i18n.client.Dictionary
 */
public class ConsoleConfig
{
  private String consoleServerUrl;
  private String reportServerUrl;

  private String overviewReportFile;
  private String definitionReportFile;
  private String instanceReportFile;


  public ConsoleConfig(String consoleServerUrl, String reportServerUrl)
  {
    this.consoleServerUrl = consoleServerUrl;
    this.reportServerUrl = reportServerUrl;
  }

  public ConsoleConfig()
  {
    Dictionary theme = Dictionary.getDictionary("consoleConfig");
    consoleServerUrl = theme.get("consoleServerUrl");
    reportServerUrl = theme.get("reportServerUrl");

    overviewReportFile = theme.get("overviewReportFile");
    definitionReportFile = theme.get("definitionReportFile");
    instanceReportFile = theme.get("instanceReportFile");
  }

  public String getConsoleServerUrl()
  {
    return consoleServerUrl;
  }

  public void setConsoleServerUrl(String consoleServerUrl)
  {
    this.consoleServerUrl = consoleServerUrl;
  }

  public String getReportServerUrl()
  {
    return reportServerUrl;
  }

  public void setReportServerUrl(String reportServerUrl)
  {
    this.reportServerUrl = reportServerUrl;
  }

  public String getOverviewReportFile()
  {
    return overviewReportFile;
  }

  public void setOverviewReportFile(String overviewReportFile)
  {
    this.overviewReportFile = overviewReportFile;
  }

  public String getDefinitionReportFile()
  {
    return definitionReportFile;
  }

  public void setDefinitionReportFile(String definitionReportFile)
  {
    this.definitionReportFile = definitionReportFile;
  }

  public String getInstanceReportFile()
  {
    return instanceReportFile;
  }

  public void setInstanceReportFile(String instanceReportFile)
  {
    this.instanceReportFile = instanceReportFile;
  }
}
