/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.bpm.console.client;


import org.gwt.mosaic.ui.client.StackLayoutPanel;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import com.mvc4g.client.ViewInterface;
import com.mvc4g.client.Controller;

/**
 * The main menu on the left hand.
 * Keeps a list of {@link org.jboss.bpm.console.client.MenuSection}.
 *
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class Menu extends LayoutPanel implements ViewInterface
{  
  private StackLayoutPanel stack;  
  private Controller controller;

  public Menu()
  {
    super(new BoxLayout(BoxLayout.Orientation.VERTICAL));

    this.setWidgetSpacing(5);

    this.stack = new StackLayoutPanel();
    //stack.showStack(0); // todo: loading event
    this.add(stack, new BoxLayoutData(BoxLayoutData.FillStyle.BOTH, true));
  }

  public void addSection(MenuSection menuSection)
  {    
    this.stack.add(menuSection, menuSection.getMenuTitle(), true);
  }

  public void setController(Controller controller)
  {
    this.controller = controller;
  }
}
