/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.URL;
import org.jboss.bpm.console.client.ConsoleConfig;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.jbpm3.TokenReference;

public class URLBuilder {
    ConsoleConfig config;

    public URLBuilder(ConsoleConfig config) {
        this.config = config;
    }

    public String getConsoleServerUrl() {
        return this.config.getConsoleServerUrl();
    }

    public String getProcessDefinitionsURL() {
        return this.getConsoleServerUrl() + "/rs/process/definitions";
    }

    public String getProcessInstancesURL(String processId) {
        String encodedId = URL.encode((String)processId);
        return this.getConsoleServerUrl() + "/rs/process/definitions/" + encodedId + "/instances";
    }

    public String getUserInRoleURL(String[] possibleRoles) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < possibleRoles.length; ++i) {
            sb.append(URL.encode((String)possibleRoles[i]));
            if (i >= possibleRoles.length - 1) continue;
            sb.append(",");
        }
        return this.getConsoleServerUrl() + "/rs/identity/user/roles?roleCheck=" + sb.toString();
    }

    public String getServerStatusURL() {
        return this.getConsoleServerUrl() + "/rs/server/status";
    }

    @Deprecated
    public String getRemoveDefinitionURL(String processId) {
        String encodedId = URL.encode((String)processId);
        return this.getConsoleServerUrl() + "/rs/process/definitions/" + encodedId + "/remove";
    }

    public String getProcessImageURL(String processId) {
        String encodedId = URL.encode((String)processId);
        return this.getConsoleServerUrl() + "/rs/jbpm3/definitions/" + encodedId + "/image";
    }

    public String getActiveNodeInfoURL(String instanceId) {
        return this.getConsoleServerUrl() + "/rs/jbpm3/instances/" + instanceId + "/activeNodeInfo";
    }

    public String getStateChangeURL(String instanceId, ProcessInstanceRef.STATE state) {
        return this.getConsoleServerUrl() + "/rs/process/instances/" + instanceId + "/state/" + state;
    }

    public String getStartNewInstanceURL(String processId) {
        String encodedID = URL.encode((String)processId);
        return this.getConsoleServerUrl() + "/rs/process/definitions/" + encodedID + "/instances/new";
    }

    public String getUploadDefinitionURL() {
        return this.getConsoleServerUrl() + "/rs/process/definitions/new";
    }

    public String getTaskListURL(String idRef) {
        return this.getConsoleServerUrl() + "/rs/tasks/" + URL.encode((String)idRef);
    }

    public String getParticipationTaskListURL(String idRef, String participation) {
        return this.getConsoleServerUrl() + "/rs/tasks/" + URL.encode((String)idRef) + "/participation/" + URL.encode((String)participation);
    }

    public String getTaskReleaseURL(long id) {
        return this.getConsoleServerUrl() + "/rs/task/" + id + "/release";
    }

    public String getTaskCompleteURL(long id) {
        return this.getConsoleServerUrl() + "/rs/task/" + id + "/close";
    }

    public String getTaskCompleteURL(long id, String outcome) {
        return this.getConsoleServerUrl() + "/rs/task/" + id + "/close/" + URL.encode((String)outcome);
    }

    public String getTaskAssignURL(long id, String idRef) {
        return this.getConsoleServerUrl() + "/rs/task/" + id + "/assign/" + URL.encode((String)idRef);
    }

    public String getExecutionSignalUrl(TokenReference tok) {
        return this.getConsoleServerUrl() + "/rs/process/tokens/" + tok.getId() + "/transition/default";
    }

    public String getExecutionSignalUrl(TokenReference tok, String signal) {
        String encodedSignal = URL.encode((String)signal);
        return this.getConsoleServerUrl() + "/rs/process/tokens/" + tok.getId() + "/transition?signal=" + encodedSignal;
    }

    public String getAvailableActorsUrl(String actorId) {
        return this.getConsoleServerUrl() + "/rs/identity/user/" + actorId + "/actors";
    }

    public String getProcessDefinitionByNameURL(String name) {
        return this.getConsoleServerUrl() + "/rs/process/definitions/" + name;
    }

    public String getDeployTestHarnessUrl() {
        return this.getConsoleServerUrl() + "/rs/test/deploy/harness";
    }

    public String getUndeployTestHarnessUrl() {
        return this.getConsoleServerUrl() + "/rs/test/undeploy/harness";
    }

    public String getOverviewReportUrl() {
        String name = URL.encode((String)this.config.getOverviewReportFile());
        String url = this.config.getReportServerUrl() + "/rs/report/view/" + name;
        if (!GWT.isScript()) {
            url = url + "?id=birt";
        }
        return url;
    }

    public String getDefinitionReportUrl(String name) {
        String reportName = URL.encode((String)name);
        String reportFileName = URL.encode((String)this.config.getDefinitionReportFile());
        String url = this.config.getReportServerUrl() + "/rs/report/view/" + reportFileName + "?name=" + reportName;
        if (!GWT.isScript()) {
            url = url + "&id=birt";
        }
        return url;
    }
}

