/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.model;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jboss.bpm.console.client.model.ParticipantRef;
import org.jboss.bpm.console.client.model.PluginInfo;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.ServerStatus;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.model.jbpm3.TokenReference;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.JSONWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTOParser {
    public static List<ProcessDefinitionRef> parseProcessDefinitions(JSONValue jso) {
        ArrayList<ProcessDefinitionRef> results = new ArrayList<ProcessDefinitionRef>();
        JSONArray arr = JSONWalk.on(jso).next("definitions").asArray();
        for (int i = 0; i < arr.size(); ++i) {
            results.add(DTOParser.parseProcessDefinition(arr.get(i)));
        }
        return results;
    }

    public static ProcessDefinitionRef parseProcessDefinition(JSONValue root) {
        ConsoleLog.debug("parse " + root);
        String id = JSONWalk.on(root).next("id").asString();
        Long version = JSONWalk.on(root).next("version").asLong();
        String name = JSONWalk.on(root).next("name").asString();
        return new ProcessDefinitionRef(id, name, version.longValue());
    }

    public static ProcessDefinitionRef parseProcessDefinition(String json) {
        JSONValue root = JSONParser.parse((String)json);
        return DTOParser.parseProcessDefinition(root);
    }

    public static List<String> parseRolesAssigned(String json) {
        ArrayList<String> roles = new ArrayList<String>();
        JSONValue root = JSONParser.parse((String)json);
        JSONArray array = JSONWalk.on(root).next("roles").asArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject item = array.get(i).isObject();
            boolean assigned = JSONWalk.on((JSONValue)item).next("assigned").asBool();
            String roleName = JSONWalk.on((JSONValue)item).next("role").asString();
            if (!assigned) continue;
            roles.add(roleName);
        }
        return roles;
    }

    public static List<TaskRef> parseTaskReferenceList(String json) {
        ArrayList<TaskRef> results = new ArrayList<TaskRef>();
        JSONValue root = JSONParser.parse((String)json);
        JSONArray array = JSONWalk.on(root).next("tasks").asArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject item = array.get(i).isObject();
            TaskRef ref = DTOParser.parseTaskReference(item);
            results.add(ref);
        }
        return results;
    }

    public static TaskRef parseTaskReference(JSONObject item) {
        JSONWalk.JSONWrapper createDate;
        ConsoleLog.debug("parse " + item);
        long id = JSONWalk.on((JSONValue)item).next("id").asLong();
        String executionId = JSONWalk.on((JSONValue)item).next("processInstanceId").asString();
        String processId = JSONWalk.on((JSONValue)item).next("processId").asString();
        String name = JSONWalk.on((JSONValue)item).next("name").asString();
        String assignee = JSONWalk.on((JSONValue)item).next("assignee").asString();
        boolean isBlocking = JSONWalk.on((JSONValue)item).next("isBlocking").asBool();
        boolean isSignalling = JSONWalk.on((JSONValue)item).next("isSignalling").asBool();
        TaskRef ref = new TaskRef(id, executionId, processId, name, assignee, isSignalling, isBlocking);
        JSONWalk.JSONWrapper jsonWrapper = JSONWalk.on((JSONValue)item).next("url");
        if (jsonWrapper != null) {
            String url = jsonWrapper.asString();
            ref.setUrl(url);
        } else {
            ref.setUrl("");
        }
        JSONArray arrUsers = JSONWalk.on((JSONValue)item).next("participantUsers").asArray();
        for (int k = 0; k < arrUsers.size(); ++k) {
            JSONValue jsonValue = arrUsers.get(k);
            ParticipantRef p = DTOParser.parseParticipant(jsonValue, k);
            ref.getParticipantUsers().add(p);
        }
        JSONArray arrGroups = JSONWalk.on((JSONValue)item).next("participantGroups").asArray();
        for (int k = 0; k < arrGroups.size(); ++k) {
            JSONValue jsonValue = arrGroups.get(k);
            ParticipantRef p = DTOParser.parseParticipant(jsonValue, k);
            ref.getParticipantGroups().add(p);
        }
        if (isSignalling) {
            JSONArray arr = JSONWalk.on((JSONValue)item).next("outcomes").asArray();
            for (int k = 0; k < arr.size(); ++k) {
                JSONValue jsonValue = arr.get(k);
                if (jsonValue.toString().equals("null")) {
                    ConsoleLog.warn("FIXME JBPM-1828: Null value on outcomes:" + arr.toString());
                    continue;
                }
                JSONString t = jsonValue.isString();
                ref.getOutcomes().add(t.stringValue());
            }
        }
        int prio = JSONWalk.on((JSONValue)item).next("priority").asInt();
        ref.setPriority(prio);
        JSONWalk.JSONWrapper dueDate = JSONWalk.on((JSONValue)item).next("dueDate");
        if (dueDate != null) {
            Date due = dueDate.asDate();
            ref.setDueDate(due);
        }
        if ((createDate = JSONWalk.on((JSONValue)item).next("createDate")) != null) {
            Date due = createDate.asDate();
            ref.setDueDate(due);
        }
        return ref;
    }

    private static ParticipantRef parseParticipant(JSONValue jsonValue, int k) {
        String type = JSONWalk.on(jsonValue).next("type").asString();
        String idRef = JSONWalk.on(jsonValue).next("idRef").asString();
        ParticipantRef p = new ParticipantRef(type, idRef);
        boolean isGroup = JSONWalk.on(jsonValue).next("isGroup").asBool();
        p.setGroup(isGroup);
        return p;
    }

    public static List<ProcessInstanceRef> parseProcessInstances(JSONValue jso) {
        ArrayList<ProcessInstanceRef> results = new ArrayList<ProcessInstanceRef>();
        JSONArray arr = JSONWalk.on(jso).next("instances").asArray();
        for (int i = 0; i < arr.size(); ++i) {
            results.add(DTOParser.parseProcessInstance(arr.get(i)));
        }
        return results;
    }

    public static ProcessInstanceRef parseProcessInstance(JSONValue root) {
        ConsoleLog.debug("parse " + root);
        String id = JSONWalk.on(root).next("id").asString();
        String definitionId = JSONWalk.on(root).next("definitionId").asString();
        Date start = JSONWalk.on(root).next("startDate").asDate();
        JSONWalk.JSONWrapper endDateJSON = JSONWalk.on(root).next("endDate");
        Date end = null;
        if (endDateJSON != null) {
            end = endDateJSON.asDate();
        }
        boolean suspended = JSONWalk.on(root).next("suspended").asBool();
        ProcessInstanceRef processInstance = new ProcessInstanceRef(id, definitionId, start, end, suspended);
        JSONObject tokJso = JSONWalk.on(root).next("rootToken").asObject();
        TokenReference rootToken = DTOParser.parseTokenReference(tokJso);
        processInstance.setRootToken(rootToken);
        return processInstance;
    }

    public static TokenReference parseTokenReference(JSONObject jso) {
        JSONString item;
        ConsoleLog.debug("parse " + jso);
        String rootTokenId = JSONWalk.on((JSONValue)jso).next("id").asString();
        String nodeName = JSONWalk.on((JSONValue)jso).next("currentNodeName").asString();
        TokenReference rt = new TokenReference(rootTokenId, "", nodeName);
        boolean canBeSignaled = JSONWalk.on((JSONValue)jso).next("canBeSignaled").asBool();
        rt.setCanBeSignaled(canBeSignaled);
        JSONArray signals = JSONWalk.on((JSONValue)jso).next("availableSignals").asArray();
        for (int i = 0; i < signals.size(); ++i) {
            JSONValue jsonValue = signals.get(i);
            if (jsonValue.toString().equals("null")) {
                ConsoleLog.warn("FIXME JBPM-1828: Null value on availableSignals:" + signals.toString());
                continue;
            }
            item = jsonValue.isString();
            rt.getAvailableSignals().add(item.stringValue());
        }
        JSONArray childArr = JSONWalk.on((JSONValue)jso).next("children").asArray();
        for (int i = 0; i < childArr.size(); ++i) {
            item = childArr.get(i).isObject();
            rt.getChildren().add(DTOParser.parseTokenReference((JSONObject)item));
        }
        return rt;
    }

    public static List<String> parseStringArray(JSONValue jso) {
        ArrayList<String> result = new ArrayList<String>();
        JSONArray jsonArray = jso.isArray();
        if (null == jsonArray) {
            throw new IllegalArgumentException("Not an array: " + jso);
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONValue jsonValue = jsonArray.get(i);
            if (jsonValue.toString().equals("null")) {
                ConsoleLog.warn("FIXME JBPM-1828: Null value on string array:" + jsonArray.toString());
                continue;
            }
            JSONString item = jsonValue.isString();
            result.add(item.stringValue());
        }
        return result;
    }

    public static ServerStatus parseStatus(JSONValue json) {
        ConsoleLog.debug("parse " + json);
        ServerStatus status = new ServerStatus();
        JSONArray jsonArray = JSONWalk.on(json).next("plugins").asArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONValue item = jsonArray.get(i);
            String type = JSONWalk.on(item).next("type").asString();
            boolean avail = JSONWalk.on(item).next("available").asBool();
            status.getPlugins().add(new PluginInfo(type, avail));
        }
        return status;
    }
}

