/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.user.client.ui.Widget;
import org.gwt.mosaic.ui.client.DeckLayoutPanel;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.Editor;
import org.jboss.bpm.console.client.Menu;
import org.jboss.bpm.console.client.MenuSection;

public class Workspace
extends DeckLayoutPanel {
    protected ApplicationContext appContext;
    private Menu menu;

    public Workspace(Menu menu) {
        this.menu = menu;
        this.setPadding(5);
    }

    public void addEditor(Editor editor, boolean closeable) {
        MenuSection menuSection = editor.provideMenuSection();
        if (menuSection != null) {
            this.menu.addSection(menuSection);
        }
        EditorDeck deck = this.createDeck(editor);
        deck.index = this.getWidgetCount();
        this.add((Widget)deck);
    }

    public boolean hasEditor(String id) {
        return this.findEditor(id) != null;
    }

    public void showEditor(String id) {
        EditorDeck deck = this.findEditor(id);
        if (null == deck) {
            throw new IllegalArgumentException("No such editor: " + id);
        }
        this.showWidget(deck.index);
        deck.editor.initialize();
    }

    private EditorDeck createDeck(Editor editor) {
        EditorDeck deck = new EditorDeck(editor);
        deck.add((Widget)editor);
        return deck;
    }

    private EditorDeck findEditor(String id) {
        EditorDeck match = null;
        for (int i = 0; i < this.getWidgetCount(); ++i) {
            EditorDeck deck = (EditorDeck)this.getWidget(i);
            if (!id.equals(deck.editor.getEditorId())) continue;
            match = deck;
            break;
        }
        return match;
    }

    private class EditorDeck
    extends LayoutPanel {
        Editor editor;
        int index;

        public EditorDeck(Editor editor) {
            this.editor = editor;
        }
    }
}

