/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.bmunit;

import java.lang.annotation.Annotation;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMRules;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMScripts;
import org.jboss.byteman.contrib.bmunit.BMUnit;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class BMUnitRunner
extends BlockJUnit4ClassRunner {
    BMScript classSingleScriptAnnotation;
    BMScripts classMultiScriptAnnotation;
    BMRules classMultiRuleAnnotation;
    BMRule classSingleRuleAnnotation;
    Class<?> testKlazz = this.getTestClass().getJavaClass();
    String loadDirectory;

    public BMUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.classSingleScriptAnnotation = this.testKlazz.getAnnotation(BMScript.class);
        this.classMultiScriptAnnotation = this.testKlazz.getAnnotation(BMScripts.class);
        this.classMultiRuleAnnotation = this.testKlazz.getAnnotation(BMRules.class);
        this.classSingleRuleAnnotation = this.testKlazz.getAnnotation(BMRule.class);
        if (this.classMultiRuleAnnotation != null && this.classSingleRuleAnnotation != null) {
            throw new InitializationError("Use either BMRule or BMRules annotation but not both");
        }
        if (this.classMultiScriptAnnotation != null && this.classSingleScriptAnnotation != null) {
            throw new InitializationError("Use either BMScript or BMScripts annotation but not both");
        }
    }

    protected Statement childrenInvoker(RunNotifier notifier) {
        Statement statement = super.childrenInvoker(notifier);
        statement = this.addClassSingleRuleLoader(statement, notifier);
        statement = this.addClassMultiRuleLoader(statement, notifier);
        statement = this.addClassSingleScriptLoader(statement, notifier);
        statement = this.addClassMultiScriptLoader(statement, notifier);
        return statement;
    }

    protected Statement addClassSingleScriptLoader(final Statement statement, RunNotifier notifier) {
        if (this.classSingleScriptAnnotation == null) {
            return statement;
        }
        final String name = this.computeBMRulesName(this.classSingleScriptAnnotation.value(), this.testKlazz);
        final RunNotifier fnotifier = notifier;
        final Description description = Description.createTestDescription(this.testKlazz, (String)this.getName(), (Annotation[])new Annotation[]{this.classSingleScriptAnnotation});
        final String loadDirectory = this.normaliseLoadDirectory(this.classSingleScriptAnnotation);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    BMUnit.loadScriptFile(BMUnitRunner.this.testKlazz, name, loadDirectory);
                    try {
                        statement.evaluate();
                    }
                    finally {
                        try {
                            BMUnit.unloadScriptFile(BMUnitRunner.this.testKlazz, name);
                        }
                        catch (Exception e) {
                            fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                        }
                    }
                }
                catch (Exception e) {
                    fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                }
            }
        };
    }

    protected Statement addClassMultiScriptLoader(Statement statement, RunNotifier notifier) {
        if (this.classMultiScriptAnnotation == null) {
            return statement;
        }
        BMScript[] scriptAnnotations = this.classMultiScriptAnnotation.scripts();
        Statement result = statement;
        for (int i = scriptAnnotations.length; i > 0; --i) {
            BMScript scriptAnnotation = scriptAnnotations[i - 1];
            final String name = this.computeBMRulesName(scriptAnnotation.value(), this.testKlazz);
            final RunNotifier fnotifier = notifier;
            final Description description = Description.createTestDescription(this.testKlazz, (String)this.getName(), (Annotation[])new Annotation[]{scriptAnnotation});
            final String loadDirectory = this.normaliseLoadDirectory(scriptAnnotation);
            final Statement nextStatement = result;
            result = new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    try {
                        BMUnit.loadScriptFile(BMUnitRunner.this.testKlazz, name, loadDirectory);
                        try {
                            nextStatement.evaluate();
                        }
                        finally {
                            try {
                                BMUnit.unloadScriptFile(BMUnitRunner.this.testKlazz, name);
                            }
                            catch (Exception e) {
                                fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                            }
                        }
                    }
                    catch (Exception e) {
                        fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                    }
                }
            };
        }
        return result;
    }

    protected Statement addClassMultiRuleLoader(final Statement statement, RunNotifier notifier) {
        if (this.classMultiRuleAnnotation == null) {
            return statement;
        }
        final String scriptText = this.constructScriptText(this.classMultiRuleAnnotation.rules());
        final RunNotifier fnotifier = notifier;
        final Description description = Description.createTestDescription(this.testKlazz, (String)this.getName(), (Annotation[])new Annotation[]{this.classMultiRuleAnnotation});
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    BMUnit.loadScriptText(BMUnitRunner.this.testKlazz, null, scriptText);
                    try {
                        statement.evaluate();
                    }
                    finally {
                        try {
                            BMUnit.unloadScriptText(BMUnitRunner.this.testKlazz, null);
                        }
                        catch (Exception e) {
                            fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                        }
                    }
                }
                catch (Exception e) {
                    fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                }
            }
        };
    }

    protected Statement addClassSingleRuleLoader(final Statement statement, RunNotifier notifier) {
        if (this.classSingleRuleAnnotation == null) {
            return statement;
        }
        final String scriptText = this.constructScriptText(new BMRule[]{this.classSingleRuleAnnotation});
        final RunNotifier fnotifier = notifier;
        final Description description = Description.createTestDescription(this.testKlazz, (String)this.getName(), (Annotation[])new Annotation[]{this.classSingleRuleAnnotation});
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    BMUnit.loadScriptText(BMUnitRunner.this.testKlazz, null, scriptText);
                    try {
                        statement.evaluate();
                    }
                    finally {
                        try {
                            BMUnit.unloadScriptText(BMUnitRunner.this.testKlazz, null);
                        }
                        catch (Exception e) {
                            fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                        }
                    }
                }
                catch (Exception e) {
                    fnotifier.fireTestFailure(new Failure(description, (Throwable)e));
                }
            }
        };
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        Statement statement = super.methodInvoker(method, test);
        statement = this.addMethodSingleRuleLoader(statement, method);
        statement = this.addMethodMultiRuleLoader(statement, method);
        statement = this.addMethodSingleScriptLoader(statement, method);
        statement = this.addMethodMultiScriptLoader(statement, method);
        return statement;
    }

    protected Statement addMethodSingleScriptLoader(final Statement statement, FrameworkMethod method) {
        BMScript annotation = (BMScript)method.getAnnotation(BMScript.class);
        if (annotation == null) {
            return statement;
        }
        final String name = this.computeBMRulesName(annotation.value(), method);
        final String loadDirectory = this.computeLoadDirectory(annotation.dir(), this.loadDirectory);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                BMUnit.loadScriptFile(BMUnitRunner.this.testKlazz, name, loadDirectory);
                try {
                    statement.evaluate();
                }
                finally {
                    BMUnit.unloadScriptFile(BMUnitRunner.this.testKlazz, name);
                }
            }
        };
    }

    protected Statement addMethodMultiScriptLoader(Statement statement, FrameworkMethod method) {
        BMScripts scriptsAnnotation = (BMScripts)method.getAnnotation(BMScripts.class);
        if (scriptsAnnotation == null) {
            return statement;
        }
        BMScript[] scriptAnnotations = scriptsAnnotation.scripts();
        Statement result = statement;
        for (int i = scriptAnnotations.length; i > 0; --i) {
            BMScript scriptAnnotation = scriptAnnotations[i - 1];
            final Statement nextStatement = result;
            final String name = this.computeBMRulesName(scriptAnnotation.value(), method);
            final String loadDirectory = this.computeLoadDirectory(scriptAnnotation.dir(), this.loadDirectory);
            result = new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    BMUnit.loadScriptFile(BMUnitRunner.this.testKlazz, name, loadDirectory);
                    try {
                        nextStatement.evaluate();
                    }
                    finally {
                        BMUnit.unloadScriptFile(BMUnitRunner.this.testKlazz, name);
                    }
                }
            };
        }
        return result;
    }

    protected Statement addMethodMultiRuleLoader(final Statement statement, FrameworkMethod method) {
        BMRules annotation = (BMRules)method.getAnnotation(BMRules.class);
        if (annotation == null) {
            return statement;
        }
        final String name = method.getName();
        final String script = this.constructScriptText(annotation.rules());
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                BMUnit.loadScriptText(BMUnitRunner.this.testKlazz, name, script);
                try {
                    statement.evaluate();
                }
                finally {
                    BMUnit.unloadScriptText(BMUnitRunner.this.testKlazz, name);
                }
            }
        };
    }

    protected Statement addMethodSingleRuleLoader(final Statement statement, FrameworkMethod method) {
        BMRule annotation = (BMRule)method.getAnnotation(BMRule.class);
        if (annotation == null) {
            return statement;
        }
        final String name = method.getName();
        final String script = this.constructScriptText(new BMRule[]{annotation});
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                BMUnit.loadScriptText(BMUnitRunner.this.testKlazz, name, script);
                try {
                    statement.evaluate();
                }
                finally {
                    BMUnit.unloadScriptText(BMUnitRunner.this.testKlazz, name);
                }
            }
        };
    }

    public String normaliseLoadDirectory(BMScript annotation) {
        String loadDirectory = annotation.dir();
        if (loadDirectory != null && loadDirectory.length() > 0) {
            return loadDirectory;
        }
        return null;
    }

    protected String constructScriptText(BMRule[] bmRules) {
        StringBuilder builder = new StringBuilder();
        builder.append("# BMUnit autogenerated script ");
        for (BMRule bmRule : bmRules) {
            String helper;
            builder.append("\nRULE ");
            builder.append(bmRule.name());
            if (bmRule.isInterface()) {
                builder.append("\nINTERFACE ");
            } else {
                builder.append("\nCLASS ");
            }
            if (bmRule.isOverriding()) {
                builder.append("^");
            }
            builder.append(bmRule.targetClass());
            builder.append("\nMETHOD ");
            builder.append(bmRule.targetMethod());
            String location = bmRule.targetLocation();
            if (location != null && location.length() > 0) {
                builder.append("\nAT ");
                builder.append(location);
            }
            if ((helper = bmRule.helper()) != null && helper.length() > 0) {
                builder.append("\nHELPER ");
                builder.append(helper);
            }
            builder.append("\nIF ");
            builder.append(bmRule.condition());
            builder.append("\nDO ");
            builder.append(bmRule.action());
            builder.append("\nENDRULE\n");
        }
        return builder.toString();
    }

    protected String computeBMRulesName(String name, FrameworkMethod method) {
        if (name != null && name.length() > 0) {
            return name;
        }
        return method.getName();
    }

    protected String computeBMRulesName(String name, Class<?> testClass) {
        if (name != null && name.length() > 0) {
            return name;
        }
        return null;
    }

    protected String computeLoadDirectory(String methodAnnotationDir, String classAnnotationDir) {
        if (methodAnnotationDir != null && methodAnnotationDir.length() > 0) {
            return methodAnnotationDir;
        }
        return classAnnotationDir;
    }
}

