/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.bmunit;

import com.sun.tools.attach.AgentInitializationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Properties;
import org.jboss.byteman.agent.install.Install;
import org.jboss.byteman.agent.install.VMInfo;
import org.jboss.byteman.agent.submit.Submit;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;

public class BMUnitConfigState {
    private static BMUnitConfigState currentConfigState = null;
    private static BMUnitConfigState shadowConfigState = null;
    public static BMUnitConfigState defaultConfigState = null;
    private String agentHost;
    private int agentPort;
    private String loadDirectory;
    private String resourceLoadDirectory;
    private boolean allowConfigUpdate;
    private boolean verbose;
    private boolean debug;
    private boolean bmunitVerbose;
    private boolean inhibitAgentLoad;
    private boolean policy;
    private BMUnitConfigState previous;
    public static final String LOAD_DIRECTORY = "org.jboss.byteman.contrib.bmunit.load.directory";
    public static final String RESOURCE_LOAD_DIRECTORY = "org.jboss.byteman.contrib.bmunit.resource.load.directory";
    public static final String AGENT_PORT = "org.jboss.byteman.contrib.bmunit.agent.port";
    public static final String AGENT_HOST = "org.jboss.byteman.contrib.bmunit.agent.host";
    public static final String AGENT_POLICY = "org.jboss.byteman.contrib.bmunit.agent.policy";
    public static final String AGENT_INHIBIT = "org.jboss.byteman.contrib.bmunit.agent.inhibit";
    public static final String BYTEMAN_VERBOSE = "org.jboss.byteman.verbose";
    public static final String BYTEMAN_DEBUG = "org.jboss.byteman.debug";
    public static final String BMUNIT_VERBOSE = "org.jboss.byteman.contrib.bmunit.verbose";
    public static final String VERBOSE = "org.jboss.byteman.contrib.bmunit.verbose";

    private BMUnitConfigState(BMUnitConfig config, BMUnitConfigState previous) throws Exception {
        this.previous = previous;
        boolean enforce = config.enforce();
        this.agentHost = config.agentHost();
        if (previous == null && (this.agentHost == null || this.agentHost.length() == 0)) {
            this.agentHost = BMUnitConfigState.initHost();
        }
        String agentPortString = config.agentPort();
        if (previous == null && (agentPortString == null || agentPortString.length() == 0)) {
            this.agentPort = BMUnitConfigState.initPort();
            if (this.agentPort < 0) {
                this.agentPort = 0;
            }
        } else {
            try {
                this.agentPort = Integer.valueOf(agentPortString);
            }
            catch (NumberFormatException e) {
                this.agentPort = 0;
            }
            if (this.agentPort < 0) {
                this.agentPort = 0;
            }
        }
        this.loadDirectory = config.loadDirectory();
        if (previous == null && (this.loadDirectory == null || this.loadDirectory.length() == 0)) {
            this.loadDirectory = BMUnitConfigState.initDefaultLoadDirectory();
        }
        this.resourceLoadDirectory = config.resourceLoadDirectory();
        if (previous == null && (this.resourceLoadDirectory == null || this.resourceLoadDirectory.length() == 0)) {
            this.resourceLoadDirectory = BMUnitConfigState.initDefaultResourceLoadDirectory();
        }
        this.allowConfigUpdate = config.allowAgentConfigUpdate();
        if (previous != null && this.allowConfigUpdate != previous.allowConfigUpdate && enforce) {
            String message = "BMUnit configuration specifies incompatible settings for allowAgentConfigUpdate";
            throw new Exception(message);
        }
        this.verbose = config.verbose();
        if (previous != null && this.verbose != previous.verbose && !this.allowConfigUpdate && enforce) {
            String message = "BMUnit configuration specifies incompatible settings for verbose";
            throw new Exception(message);
        }
        if (previous == null && !this.verbose) {
            this.verbose = BMUnitConfigState.initVerbose();
        }
        this.debug = config.debug();
        if (previous != null && this.debug != previous.debug && !this.allowConfigUpdate && enforce) {
            String message = "BMUnit configuration specifies incompatible settings for debug";
            throw new Exception(message);
        }
        if (previous == null && !this.debug) {
            this.debug = BMUnitConfigState.initDebug();
        }
        this.bmunitVerbose = config.bmunitVerbose();
        if (previous == null && !this.bmunitVerbose) {
            this.bmunitVerbose = BMUnitConfigState.initBMUnitVerbose();
        }
        this.inhibitAgentLoad = config.inhibitAgentLoad();
        if (previous != null && this.inhibitAgentLoad != previous.inhibitAgentLoad && enforce) {
            String message = "BMUnit configuration specifies incompatible settings for inhibitAgentLoad";
            throw new Exception(message);
        }
        if (previous == null && !this.inhibitAgentLoad) {
            this.inhibitAgentLoad = System.getProperty(AGENT_INHIBIT) != null;
        }
        this.policy = config.policy();
        if (previous != null && previous.policy != this.policy && enforce) {
            String message = "BMUnit configuration specifies incompatible settings for inhibitAgentLoad";
            throw new Exception(message);
        }
    }

    private BMUnitConfigState(BMUnitConfigState previous) throws Exception {
        this.previous = previous;
        if (previous != null) {
            this.agentHost = previous.agentHost;
            this.agentPort = previous.agentPort;
            this.loadDirectory = previous.loadDirectory;
            this.resourceLoadDirectory = previous.resourceLoadDirectory;
            this.allowConfigUpdate = previous.allowConfigUpdate;
            this.verbose = previous.verbose;
            this.bmunitVerbose = previous.bmunitVerbose;
            this.inhibitAgentLoad = previous.inhibitAgentLoad;
            this.policy = previous.policy;
        } else {
            this.agentHost = BMUnitConfigState.initHost();
            this.agentPort = BMUnitConfigState.initPort();
            this.loadDirectory = BMUnitConfigState.initDefaultLoadDirectory();
            this.resourceLoadDirectory = BMUnitConfigState.initDefaultResourceLoadDirectory();
            this.allowConfigUpdate = true;
            this.verbose = BMUnitConfigState.initVerbose();
            this.debug = BMUnitConfigState.initDebug();
            this.bmunitVerbose = BMUnitConfigState.initBMUnitVerbose();
            this.inhibitAgentLoad = System.getProperty(AGENT_INHIBIT) != null;
            this.policy = BMUnitConfigState.initPolicy();
        }
    }

    private static void uploadAgentProperties() throws Exception {
        BMUnitConfigState previousConfigState = BMUnitConfigState.currentConfigState.previous;
        if (previousConfigState != null && previousConfigState.isAllowConfigUpdate() && (BMUnitConfigState.currentConfigState.verbose != previousConfigState.verbose || BMUnitConfigState.currentConfigState.debug != previousConfigState.debug)) {
            Submit submit = new Submit(currentConfigState.getHost(), currentConfigState.getPort());
            Properties properties = new Properties();
            properties.setProperty(BYTEMAN_VERBOSE, BMUnitConfigState.currentConfigState.verbose ? "true" : "");
            properties.setProperty(BYTEMAN_DEBUG, BMUnitConfigState.currentConfigState.debug ? "true" : "");
            submit.setSystemProperties(properties);
        }
    }

    private static void resetAgentProperties() throws Exception {
        BMUnitConfigState previousConfigState = BMUnitConfigState.currentConfigState.previous;
        if (previousConfigState != null && previousConfigState.isAllowConfigUpdate() && (BMUnitConfigState.currentConfigState.verbose != previousConfigState.verbose || BMUnitConfigState.currentConfigState.debug != previousConfigState.debug)) {
            Submit submit = new Submit(currentConfigState.getHost(), currentConfigState.getPort());
            Properties properties = new Properties();
            properties.setProperty(BYTEMAN_VERBOSE, previousConfigState.verbose ? "true" : "");
            properties.setProperty(BYTEMAN_DEBUG, previousConfigState.debug ? "true" : "");
            submit.setSystemProperties(properties);
        }
    }

    private void loadAgent() throws Exception {
        LinkedList<String> propList = new LinkedList<String>();
        String id = null;
        int pid = BMUnitConfigState.getPid();
        if (pid > 0) {
            id = Integer.toString(pid);
        } else {
            String processName;
            String prop = "org.jboss.byteman.contrib.bmunit.agent.unique";
            String unique = Long.toHexString(System.currentTimeMillis());
            System.setProperty(prop, unique);
            VMInfo[] vmInfo = Install.availableVMs();
            for (int i = 0; i < vmInfo.length; ++i) {
                String nextId = vmInfo[i].getId();
                String value = Install.getSystemProperty((String)nextId, (String)prop);
                if (!unique.equals(value)) continue;
                id = nextId;
                break;
            }
            if (id == null && (processName = ManagementFactory.getRuntimeMXBean().getName()) != null && processName.contains("@")) {
                id = processName.substring(0, processName.indexOf("@"));
                try {
                    Integer.parseInt(id);
                    String value = Install.getSystemProperty((String)id, (String)prop);
                    if (!unique.equals(value)) {
                        id = null;
                    }
                }
                catch (NumberFormatException e) {
                    id = null;
                }
            }
            if (id == null) {
                throw new Exception("BMUnit : Unable to identify test JVM process during agent load");
            }
        }
        try {
            if (this.isBMUnitVerbose()) {
                System.out.println("BMUnit : loading agent id = " + id);
            }
            if (this.isAllowConfigUpdate()) {
                propList.add("org.jboss.byteman.allow.config.update=true");
            }
            if (this.isVerbose()) {
                propList.add("org.jboss.byteman.verbose=true");
            }
            if (this.isDebug()) {
                propList.add("org.jboss.byteman.debug=true");
            }
            String[] properties = new String[propList.size()];
            Install.install((String)id, (boolean)true, (boolean)this.isPolicy(), (String)this.getHost(), (int)this.getPort(), (String[])propList.toArray(properties));
        }
        catch (AgentInitializationException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPid() {
        File file = new File("/proc/self/stat");
        if (!file.exists() || !file.canRead()) {
            return 0;
        }
        FileInputStream fis = null;
        int pid = 0;
        try {
            char c;
            fis = new FileInputStream(file);
            byte[] bytes = new byte[10];
            StringBuilder builder = new StringBuilder();
            fis.read(bytes);
            for (int i = 0; i < 10 && Character.isDigit(c = (char)bytes[i]); ++i) {
                builder.append(c);
            }
            pid = Integer.valueOf(builder.toString());
        }
        catch (Exception e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e1) {}
            }
        }
        return pid;
    }

    public static void pushConfigurationState(BMUnitConfig config, Class<?> testClass) throws Exception {
        if (currentConfigState != null) {
            throw new Exception("BMUnit test class configuration pushed without prior pop!");
        }
        currentConfigState = config != null ? new BMUnitConfigState(config, defaultConfigState) : new BMUnitConfigState(defaultConfigState);
        if (defaultConfigState == null) {
            defaultConfigState = currentConfigState;
            if (!BMUnitConfigState.defaultConfigState.inhibitAgentLoad) {
                defaultConfigState.loadAgent();
            }
        } else {
            BMUnitConfigState.uploadAgentProperties();
        }
    }

    public static void popConfigurationState(Class<?> testClass) throws Exception {
        if (currentConfigState == null) {
            throw new Exception("BMUnit test class configuration popped without prior push!");
        }
        if (shadowConfigState != null) {
            throw new Exception("BMUnit test class configuration popped without popping method configuration!");
        }
        BMUnitConfigState.resetAgentProperties();
        currentConfigState = null;
    }

    public static void pushConfigurationState(BMUnitConfig config, Method method) throws Exception {
        if (currentConfigState == null) {
            throw new Exception("BMUnit method configuration pushed without prior test configuration push!");
        }
        if (shadowConfigState != null) {
            throw new Exception("BMUnit method configuration pushed without prior method configuration pop!");
        }
        shadowConfigState = currentConfigState;
        if (config != null) {
            currentConfigState = new BMUnitConfigState(config, currentConfigState);
            BMUnitConfigState.uploadAgentProperties();
        } else {
            currentConfigState = new BMUnitConfigState(currentConfigState);
        }
    }

    public static void popConfigurationState(Method method) throws Exception {
        if (shadowConfigState == null) {
            throw new Exception("BMUnit method configuration pushed without prior method configuration pop!");
        }
        BMUnitConfigState.resetAgentProperties();
        currentConfigState = shadowConfigState;
        shadowConfigState = null;
    }

    public static void resetConfigurationState(Method method) throws Exception {
        if (shadowConfigState != null) {
            BMUnitConfigState.popConfigurationState(method);
        }
    }

    public static void resetConfigurationState(Class<?> testClass) throws Exception {
        if (currentConfigState != null) {
            BMUnitConfigState.popConfigurationState(testClass);
        }
    }

    public static BMUnitConfigState getCurrentConfigState() {
        return currentConfigState;
    }

    public BMUnitConfigState currentConfigState() {
        return currentConfigState;
    }

    public String getHost() {
        return this.agentHost;
    }

    public int getPort() {
        if (this.agentPort == 0 && this.previous != null) {
            return this.previous.getPort();
        }
        return this.agentPort;
    }

    public String getLoadDirectory() {
        if ((this.loadDirectory != null || this.loadDirectory.length() == 0) && this.previous != null) {
            return this.previous.getLoadDirectory();
        }
        return this.loadDirectory;
    }

    public String getResourceLoadDirectory() {
        if ((this.resourceLoadDirectory != null || this.resourceLoadDirectory.length() == 0) && this.previous != null) {
            return this.previous.getResourceLoadDirectory();
        }
        return this.resourceLoadDirectory;
    }

    public boolean isAllowConfigUpdate() {
        if (this.previous != null) {
            return this.previous.isAllowConfigUpdate();
        }
        return this.allowConfigUpdate;
    }

    public boolean isVerbose() {
        if (this.previous == null || this.previous.isAllowConfigUpdate()) {
            return this.verbose;
        }
        return this.previous.isVerbose();
    }

    public boolean isDebug() {
        if (this.previous == null || this.previous.isAllowConfigUpdate()) {
            return this.debug;
        }
        return this.previous.isDebug();
    }

    public boolean isBMUnitVerbose() {
        return this.bmunitVerbose;
    }

    public boolean isInhibitAgentLoad() {
        if (this.previous != null) {
            return this.previous.isInhibitAgentLoad();
        }
        return this.inhibitAgentLoad;
    }

    public boolean isPolicy() {
        if (this.previous != null) {
            return this.previous.isPolicy();
        }
        return this.policy;
    }

    private static String initHost() {
        String host = System.getProperty(AGENT_HOST);
        return host != null ? host : "";
    }

    private static int initPort() {
        String portString = System.getProperty(AGENT_PORT);
        return portString == null ? 0 : Integer.valueOf(portString);
    }

    private static String initDefaultLoadDirectory() {
        String dir = System.getProperty(LOAD_DIRECTORY);
        if (dir == null) {
            return "";
        }
        return dir;
    }

    private static String initDefaultResourceLoadDirectory() {
        int l;
        String dir = System.getProperty(RESOURCE_LOAD_DIRECTORY);
        if (dir == null && (dir = System.getProperty(LOAD_DIRECTORY)) == null) {
            dir = "";
        }
        if ((l = dir.length()) > 0 && dir.charAt(l) != '/') {
            dir = dir + "/";
        }
        return dir;
    }

    private static boolean initVerbose() {
        return System.getProperty(BYTEMAN_VERBOSE) != null;
    }

    private static boolean initDebug() {
        return System.getProperty(BYTEMAN_DEBUG) != null;
    }

    private static boolean initBMUnitVerbose() {
        return System.getProperty("org.jboss.byteman.contrib.bmunit.verbose") != null;
    }

    private static boolean initPolicy() {
        String policyString = System.getProperty(AGENT_POLICY);
        return policyString == null ? false : Boolean.valueOf(policyString);
    }
}

