/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.bmunit;

import com.sun.tools.attach.AgentInitializationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Properties;
import org.jboss.byteman.agent.install.Install;
import org.jboss.byteman.agent.install.VMInfo;
import org.jboss.byteman.agent.submit.Submit;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;

public class BMUnitConfigState {
    private static BMUnitConfigState currentConfigState = null;
    private static BMUnitConfigState shadowConfigState = null;
    public static BMUnitConfigState defaultConfigState = null;
    private String agentHost;
    private int agentPort;
    private String loadDirectory;
    private String resourceLoadDirectory;
    private boolean allowConfigUpdate;
    private boolean verbose;
    private boolean debug;
    private boolean bmunitVerbose;
    private boolean inhibitAgentLoad;
    private boolean policy;
    private boolean dumpGeneratedClasses;
    private String dumpGeneratedClassesDirectory;
    private boolean dumpGeneratedClassesIntermediate;
    private BMUnitConfigState previous;
    public static final String LOAD_DIRECTORY = "org.jboss.byteman.contrib.bmunit.load.directory";
    public static final String RESOURCE_LOAD_DIRECTORY = "org.jboss.byteman.contrib.bmunit.resource.load.directory";
    public static final String AGENT_PORT = "org.jboss.byteman.contrib.bmunit.agent.port";
    public static final String AGENT_HOST = "org.jboss.byteman.contrib.bmunit.agent.host";
    public static final String AGENT_POLICY = "org.jboss.byteman.contrib.bmunit.agent.policy";
    public static final String AGENT_INHIBIT = "org.jboss.byteman.contrib.bmunit.agent.inhibit";
    public static final String BYTEMAN_ALLOW_CONFIG_UPDATE = "org.jboss.byteman.allow.config.update";
    public static final String BYTEMAN_VERBOSE = "org.jboss.byteman.verbose";
    public static final String BYTEMAN_DEBUG = "org.jboss.byteman.debug";
    public static final String BMUNIT_VERBOSE = "org.jboss.byteman.contrib.bmunit.verbose";
    public static final String BYTEMAN_DUMP_GENERATED_CLASSES = "org.jboss.byteman.dump.generated.classes";
    public static final String BYTEMAN_DUMP_GENERATED_CLASSES_DIRECTORY = "org.jboss.byteman.dump.generated.classes.directory";
    public static final String BYTEMAN_DUMP_GENERATED_CLASSES_INTERMEDIATE = "org.jboss.byteman.dump.generated.classes.intermediate";
    public static final String VERBOSE = "org.jboss.byteman.contrib.bmunit.verbose";

    private BMUnitConfigState(BMUnitConfig config, BMUnitConfigState previous) throws Exception {
        this.previous = previous;
        boolean enforce = config.enforce();
        this.agentHost = config.agentHost();
        if (previous == null && (this.agentHost == null || this.agentHost.length() == 0)) {
            this.agentHost = BMUnitConfigState.initHost();
        }
        String agentPortString = config.agentPort();
        if (previous == null && (agentPortString == null || agentPortString.length() == 0)) {
            this.agentPort = BMUnitConfigState.initPort();
            if (this.agentPort < 0) {
                this.agentPort = 0;
            }
        } else {
            try {
                this.agentPort = Integer.valueOf(agentPortString);
            }
            catch (NumberFormatException e) {
                this.agentPort = 0;
            }
            if (this.agentPort < 0) {
                this.agentPort = 0;
            }
        }
        this.loadDirectory = config.loadDirectory();
        if (previous == null && (this.loadDirectory == null || this.loadDirectory.length() == 0)) {
            this.loadDirectory = BMUnitConfigState.initDefaultLoadDirectory();
        }
        this.resourceLoadDirectory = config.resourceLoadDirectory();
        if (previous == null && (this.resourceLoadDirectory == null || this.resourceLoadDirectory.length() == 0)) {
            this.resourceLoadDirectory = BMUnitConfigState.initDefaultResourceLoadDirectory();
        }
        this.allowConfigUpdate = config.allowAgentConfigUpdate();
        if (previous != null && this.allowConfigUpdate != previous.allowConfigUpdate && enforce) {
            String message = "BMUnit configuration specifies incompatible settings for allowAgentConfigUpdate";
            throw new Exception(message);
        }
        this.verbose = config.verbose();
        if (previous != null && this.verbose != previous.verbose && !this.allowConfigUpdate && enforce) {
            String message = "BMUnit configuration specifies incompatible settings for verbose";
            throw new Exception(message);
        }
        if (previous == null && !this.verbose) {
            this.verbose = BMUnitConfigState.initVerbose();
        }
        this.debug = config.debug();
        if (previous != null && this.debug != previous.debug && !this.allowConfigUpdate && enforce) {
            String message = "BMUnit configuration specifies incompatible settings for debug";
            throw new Exception(message);
        }
        if (previous == null && !this.debug) {
            this.debug = BMUnitConfigState.initDebug();
        }
        this.bmunitVerbose = config.bmunitVerbose();
        if (previous == null && !this.bmunitVerbose) {
            this.bmunitVerbose = BMUnitConfigState.initBMUnitVerbose();
        }
        this.inhibitAgentLoad = config.inhibitAgentLoad();
        if (previous != null && this.inhibitAgentLoad != previous.inhibitAgentLoad && enforce) {
            String message = "BMUnit configuration specifies incompatible settings for inhibitAgentLoad";
            throw new Exception(message);
        }
        if (previous == null && !this.inhibitAgentLoad) {
            this.inhibitAgentLoad = System.getProperty(AGENT_INHIBIT) != null;
        }
        this.policy = config.policy();
        if (previous != null && previous.policy != this.policy && enforce) {
            String message = "BMUnit configuration specifies incompatible settings for inhibitAgentLoad";
            throw new Exception(message);
        }
        this.dumpGeneratedClasses = config.dumpGeneratedClasses();
        if (previous != null && this.dumpGeneratedClasses != previous.dumpGeneratedClasses && !this.allowConfigUpdate && enforce) {
            String message = "BMUnit configuration specifies incompatible settings for dumpGeneratedClasses";
            throw new Exception(message);
        }
        if (previous == null && !this.dumpGeneratedClasses) {
            this.dumpGeneratedClasses = BMUnitConfigState.initDumpGeneratedClasses();
        }
        this.dumpGeneratedClassesDirectory = config.dumpGeneratedClassesDirectory();
        if (previous == null && (this.dumpGeneratedClassesDirectory == null || this.dumpGeneratedClassesDirectory.length() > 0)) {
            this.dumpGeneratedClassesDirectory = BMUnitConfigState.initDumpGeneratedClassesDirectory();
        }
        this.dumpGeneratedClassesIntermediate = config.dumpGeneratedClassesIntermediate();
        if (previous != null && this.dumpGeneratedClassesIntermediate != previous.dumpGeneratedClassesIntermediate && !this.allowConfigUpdate && enforce) {
            String message = "BMUnit configuration specifies incompatible settings for dumpGeneratedClassesIntermediate";
            throw new Exception(message);
        }
    }

    private BMUnitConfigState(BMUnitConfigState previous) throws Exception {
        this.previous = previous;
        if (previous != null) {
            this.agentHost = previous.agentHost;
            this.agentPort = previous.agentPort;
            this.loadDirectory = previous.loadDirectory;
            this.resourceLoadDirectory = previous.resourceLoadDirectory;
            this.allowConfigUpdate = previous.allowConfigUpdate;
            this.verbose = previous.verbose;
            this.bmunitVerbose = previous.bmunitVerbose;
            this.inhibitAgentLoad = previous.inhibitAgentLoad;
            this.policy = previous.policy;
            this.dumpGeneratedClasses = previous.dumpGeneratedClasses;
            this.dumpGeneratedClassesDirectory = previous.dumpGeneratedClassesDirectory;
            this.dumpGeneratedClassesIntermediate = previous.dumpGeneratedClassesIntermediate;
        } else {
            this.agentHost = BMUnitConfigState.initHost();
            this.agentPort = BMUnitConfigState.initPort();
            this.loadDirectory = BMUnitConfigState.initDefaultLoadDirectory();
            this.resourceLoadDirectory = BMUnitConfigState.initDefaultResourceLoadDirectory();
            this.allowConfigUpdate = true;
            this.verbose = BMUnitConfigState.initVerbose();
            this.debug = BMUnitConfigState.initDebug();
            this.bmunitVerbose = BMUnitConfigState.initBMUnitVerbose();
            this.inhibitAgentLoad = System.getProperty(AGENT_INHIBIT) != null;
            this.policy = BMUnitConfigState.initPolicy();
            this.dumpGeneratedClasses = BMUnitConfigState.initDumpGeneratedClasses();
            this.dumpGeneratedClassesDirectory = BMUnitConfigState.initDumpGeneratedClassesDirectory();
            this.dumpGeneratedClassesIntermediate = BMUnitConfigState.initDumpGeneratedClassesIntermediate();
        }
    }

    private static boolean needPropertyReset(BMUnitConfigState newConfigState, BMUnitConfigState oldConfigState) {
        if (oldConfigState == null) {
            return true;
        }
        if (newConfigState == null) {
            return false;
        }
        if (newConfigState.verbose != oldConfigState.verbose) {
            return true;
        }
        if (newConfigState.debug != oldConfigState.debug) {
            return true;
        }
        if (newConfigState.dumpGeneratedClasses != oldConfigState.dumpGeneratedClasses) {
            return true;
        }
        if (newConfigState.dumpGeneratedClasses) {
            String oldDir;
            String newDir = newConfigState.getDumpGeneratedClassesDirectory();
            if (!newDir.equals(oldDir = oldConfigState.getDumpGeneratedClassesDirectory())) {
                return true;
            }
            if (newConfigState.dumpGeneratedClassesIntermediate != oldConfigState.dumpGeneratedClassesIntermediate) {
                return true;
            }
        }
        return false;
    }

    private static boolean configurePropertyReset(BMUnitConfigState newConfigState, BMUnitConfigState oldConfigState, Properties props) {
        boolean modified = false;
        if (oldConfigState == null) {
            if (newConfigState.allowConfigUpdate) {
                props.setProperty(BYTEMAN_ALLOW_CONFIG_UPDATE, "true");
            }
            if (newConfigState.verbose) {
                props.setProperty(BYTEMAN_VERBOSE, "true");
            }
            if (newConfigState.debug) {
                props.setProperty(BYTEMAN_DEBUG, "true");
            }
            if (newConfigState.dumpGeneratedClasses) {
                props.setProperty(BYTEMAN_DUMP_GENERATED_CLASSES, "true");
                if (newConfigState.dumpGeneratedClassesDirectory.length() > 0) {
                    props.setProperty(BYTEMAN_DUMP_GENERATED_CLASSES_DIRECTORY, newConfigState.dumpGeneratedClassesDirectory);
                }
                if (newConfigState.dumpGeneratedClassesIntermediate) {
                    props.setProperty(BYTEMAN_DUMP_GENERATED_CLASSES_INTERMEDIATE, "true");
                }
            }
            return true;
        }
        if (newConfigState == null) {
            return false;
        }
        if (newConfigState.verbose != oldConfigState.verbose) {
            props.setProperty(BYTEMAN_VERBOSE, newConfigState.verbose ? "true" : "");
            modified = true;
        }
        if (newConfigState.debug != oldConfigState.debug) {
            props.setProperty(BYTEMAN_DEBUG, newConfigState.debug ? "true" : "");
            modified = true;
        }
        boolean resetDump = false;
        boolean resetDumpDir = false;
        boolean resetIntermediateDump = false;
        if (newConfigState.dumpGeneratedClasses) {
            if (oldConfigState.dumpGeneratedClasses) {
                String oldDir;
                String newDir = newConfigState.getDumpGeneratedClassesDirectory();
                resetDumpDir = !newDir.equals(oldDir = oldConfigState.getDumpGeneratedClassesDirectory());
                boolean isDumpIntermediate = newConfigState.isDumpGeneratedClassesIntermediate();
                boolean wasDumpIntermediate = newConfigState.isDumpGeneratedClassesIntermediate();
                resetIntermediateDump = isDumpIntermediate != wasDumpIntermediate;
            } else {
                resetDump = true;
                String dumpDir = newConfigState.getDumpGeneratedClassesDirectory();
                resetDumpDir = dumpDir.length() > 0;
                resetIntermediateDump = newConfigState.isDumpGeneratedClassesIntermediate();
            }
        } else if (!oldConfigState.dumpGeneratedClasses) {
            resetDump = true;
            String dumpDir = oldConfigState.getDumpGeneratedClassesDirectory();
            resetDumpDir = dumpDir.length() > 0;
            resetIntermediateDump = oldConfigState.isDumpGeneratedClassesIntermediate();
        }
        if (resetDump) {
            props.setProperty(BYTEMAN_DUMP_GENERATED_CLASSES, newConfigState.dumpGeneratedClasses ? "true" : "");
            modified = true;
        }
        if (resetDumpDir) {
            props.setProperty(BYTEMAN_DUMP_GENERATED_CLASSES_DIRECTORY, newConfigState.getDumpGeneratedClassesDirectory());
            modified = true;
        }
        if (resetIntermediateDump) {
            props.setProperty(BYTEMAN_DUMP_GENERATED_CLASSES_INTERMEDIATE, newConfigState.dumpGeneratedClassesIntermediate ? "true" : "");
            modified = true;
        }
        return modified;
    }

    private static void uploadAgentProperties() throws Exception {
        BMUnitConfigState previousConfigState = BMUnitConfigState.currentConfigState.previous;
        if (BMUnitConfigState.needPropertyReset(currentConfigState, previousConfigState)) {
            Submit submit = new Submit(currentConfigState.getHost(), currentConfigState.getPort());
            Properties properties = new Properties();
            if (BMUnitConfigState.configurePropertyReset(currentConfigState, previousConfigState, properties)) {
                submit.setSystemProperties(properties);
            }
        }
    }

    private static void resetAgentProperties() throws Exception {
        BMUnitConfigState previousConfigState = BMUnitConfigState.currentConfigState.previous;
        if (previousConfigState != null && previousConfigState.isAllowConfigUpdate() && BMUnitConfigState.needPropertyReset(previousConfigState, currentConfigState)) {
            Submit submit = new Submit(currentConfigState.getHost(), currentConfigState.getPort());
            Properties properties = new Properties();
            if (BMUnitConfigState.configurePropertyReset(previousConfigState, currentConfigState, properties)) {
                submit.setSystemProperties(properties);
            }
        }
    }

    private void loadAgent() throws Exception {
        int i;
        String id = null;
        int pid = BMUnitConfigState.getPid();
        if (pid > 0) {
            id = Integer.toString(pid);
        } else {
            String processName;
            String prop = "org.jboss.byteman.contrib.bmunit.agent.unique";
            String unique = Long.toHexString(System.currentTimeMillis());
            System.setProperty(prop, unique);
            VMInfo[] vmInfo = Install.availableVMs();
            for (i = 0; i < vmInfo.length; ++i) {
                String nextId = vmInfo[i].getId();
                String value = Install.getSystemProperty((String)nextId, (String)prop);
                if (!unique.equals(value)) continue;
                id = nextId;
                break;
            }
            if (id == null && (processName = ManagementFactory.getRuntimeMXBean().getName()) != null && processName.contains("@")) {
                id = processName.substring(0, processName.indexOf("@"));
                try {
                    Integer.parseInt(id);
                    String value = Install.getSystemProperty((String)id, (String)prop);
                    if (!unique.equals(value)) {
                        id = null;
                    }
                }
                catch (NumberFormatException e) {
                    id = null;
                }
            }
            if (id == null) {
                throw new Exception("BMUnit : Unable to identify test JVM process during agent load");
            }
        }
        try {
            if (this.isBMUnitVerbose()) {
                System.out.println("BMUnit : loading agent id = " + id);
            }
            Properties properties = new Properties();
            BMUnitConfigState.configurePropertyReset(currentConfigState, null, properties);
            int size = properties.size();
            String[] proparray = new String[size];
            i = 0;
            for (String key : properties.stringPropertyNames()) {
                proparray[i++] = key + "=" + properties.getProperty(key);
            }
            Install.install((String)id, (boolean)true, (boolean)this.isPolicy(), (String)this.getHost(), (int)this.getPort(), (String[])proparray);
        }
        catch (AgentInitializationException agentInitializationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPid() {
        File file = new File("/proc/self/stat");
        if (!file.exists() || !file.canRead()) {
            return 0;
        }
        FileInputStream fis = null;
        int pid = 0;
        try {
            char c;
            fis = new FileInputStream(file);
            byte[] bytes = new byte[10];
            StringBuilder builder = new StringBuilder();
            fis.read(bytes);
            for (int i = 0; i < 10 && Character.isDigit(c = (char)bytes[i]); ++i) {
                builder.append(c);
            }
            pid = Integer.valueOf(builder.toString());
        }
        catch (Exception exception) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return pid;
    }

    public static void pushConfigurationState(BMUnitConfig config, Class<?> testClass) throws Exception {
        if (currentConfigState != null) {
            throw new Exception("BMUnit test class configuration pushed without prior pop!");
        }
        currentConfigState = config != null ? new BMUnitConfigState(config, defaultConfigState) : new BMUnitConfigState(defaultConfigState);
        if (defaultConfigState == null) {
            defaultConfigState = currentConfigState;
            if (!BMUnitConfigState.defaultConfigState.inhibitAgentLoad) {
                defaultConfigState.loadAgent();
            }
        } else {
            BMUnitConfigState.uploadAgentProperties();
        }
    }

    public static void popConfigurationState(Class<?> testClass) throws Exception {
        if (currentConfigState == null) {
            throw new Exception("BMUnit test class configuration popped without prior push!");
        }
        if (shadowConfigState != null) {
            throw new Exception("BMUnit test class configuration popped without popping method configuration!");
        }
        BMUnitConfigState.resetAgentProperties();
        currentConfigState = null;
    }

    public static void pushConfigurationState(BMUnitConfig config, Method method) throws Exception {
        if (currentConfigState == null) {
            throw new Exception("BMUnit method configuration pushed without prior test configuration push!");
        }
        if (shadowConfigState != null) {
            throw new Exception("BMUnit method configuration pushed without prior method configuration pop!");
        }
        shadowConfigState = currentConfigState;
        if (config != null) {
            currentConfigState = new BMUnitConfigState(config, currentConfigState);
            BMUnitConfigState.uploadAgentProperties();
        } else {
            currentConfigState = new BMUnitConfigState(currentConfigState);
        }
    }

    public static void popConfigurationState(Method method) throws Exception {
        if (shadowConfigState == null) {
            throw new Exception("BMUnit method configuration pushed without prior method configuration pop!");
        }
        BMUnitConfigState.resetAgentProperties();
        currentConfigState = shadowConfigState;
        shadowConfigState = null;
    }

    public static void resetConfigurationState(Method method) throws Exception {
        if (shadowConfigState != null) {
            BMUnitConfigState.popConfigurationState(method);
        }
    }

    public static void resetConfigurationState(Class<?> testClass) throws Exception {
        if (currentConfigState != null) {
            BMUnitConfigState.popConfigurationState(testClass);
        }
    }

    public static BMUnitConfigState getCurrentConfigState() {
        return currentConfigState;
    }

    public BMUnitConfigState currentConfigState() {
        return currentConfigState;
    }

    public String getHost() {
        return this.agentHost;
    }

    public int getPort() {
        if (this.agentPort == 0 && this.previous != null) {
            return this.previous.getPort();
        }
        return this.agentPort;
    }

    public String getLoadDirectory() {
        if ((this.loadDirectory != null || this.loadDirectory.length() == 0) && this.previous != null) {
            return this.previous.getLoadDirectory();
        }
        return this.loadDirectory;
    }

    public String getResourceLoadDirectory() {
        if ((this.resourceLoadDirectory != null || this.resourceLoadDirectory.length() == 0) && this.previous != null) {
            return this.previous.getResourceLoadDirectory();
        }
        return this.resourceLoadDirectory;
    }

    public boolean isAllowConfigUpdate() {
        if (this.previous != null) {
            return this.previous.isAllowConfigUpdate();
        }
        return this.allowConfigUpdate;
    }

    public boolean isVerbose() {
        if (this.previous == null || this.previous.isAllowConfigUpdate()) {
            return this.verbose;
        }
        return this.previous.isVerbose();
    }

    public boolean isDebug() {
        if (this.previous == null || this.previous.isAllowConfigUpdate()) {
            return this.debug;
        }
        return this.previous.isDebug();
    }

    public boolean isBMUnitVerbose() {
        return this.bmunitVerbose;
    }

    public boolean isInhibitAgentLoad() {
        if (this.previous != null) {
            return this.previous.isInhibitAgentLoad();
        }
        return this.inhibitAgentLoad;
    }

    public boolean isPolicy() {
        if (this.previous != null) {
            return this.previous.isPolicy();
        }
        return this.policy;
    }

    public boolean isDumpGeneratedClasses() {
        return this.dumpGeneratedClasses;
    }

    public String getDumpGeneratedClassesDirectory() {
        if (!this.dumpGeneratedClasses) {
            return "";
        }
        if (this.dumpGeneratedClassesDirectory != null && this.dumpGeneratedClassesDirectory.length() != 0) {
            return this.dumpGeneratedClassesDirectory;
        }
        if (this.previous != null) {
            return this.previous.getDumpGeneratedClassesDirectory();
        }
        return "";
    }

    public boolean isDumpGeneratedClassesIntermediate() {
        if (!this.dumpGeneratedClasses) {
            return false;
        }
        return this.dumpGeneratedClassesIntermediate;
    }

    private static String initHost() {
        String host = System.getProperty(AGENT_HOST);
        return host != null ? host : "";
    }

    private static int initPort() {
        String portString = System.getProperty(AGENT_PORT);
        return portString == null ? 0 : Integer.valueOf(portString);
    }

    private static String initDefaultLoadDirectory() {
        String dir = System.getProperty(LOAD_DIRECTORY);
        if (dir == null) {
            return "";
        }
        return dir;
    }

    private static String initDefaultResourceLoadDirectory() {
        int l;
        String dir = System.getProperty(RESOURCE_LOAD_DIRECTORY);
        if (dir == null && (dir = System.getProperty(LOAD_DIRECTORY)) == null) {
            dir = "";
        }
        if ((l = dir.length()) > 0 && dir.charAt(l) != '/') {
            dir = dir + "/";
        }
        return dir;
    }

    private static boolean initVerbose() {
        return System.getProperty(BYTEMAN_VERBOSE) != null;
    }

    private static boolean initDebug() {
        return System.getProperty(BYTEMAN_DEBUG) != null;
    }

    private static boolean initBMUnitVerbose() {
        return System.getProperty("org.jboss.byteman.contrib.bmunit.verbose") != null;
    }

    private static boolean initPolicy() {
        String policyString = System.getProperty(AGENT_POLICY);
        return policyString == null ? false : Boolean.valueOf(policyString);
    }

    private static boolean initDumpGeneratedClasses() {
        return System.getProperty(BYTEMAN_DUMP_GENERATED_CLASSES) != null;
    }

    private static String initDumpGeneratedClassesDirectory() {
        String dir = System.getProperty(BYTEMAN_DUMP_GENERATED_CLASSES_DIRECTORY);
        if (dir == null) {
            dir = "";
        }
        return dir;
    }

    private static boolean initDumpGeneratedClassesIntermediate() {
        return System.getProperty(BYTEMAN_DUMP_GENERATED_CLASSES_INTERMEDIATE) != null;
    }
}

