/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.contrib.bmunit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.byteman.agent.submit.ScriptText;
import org.jboss.byteman.agent.submit.Submit;
import org.jboss.byteman.contrib.bmunit.BMUnitConfigState;

public class BMUnit {
    private static char fs = File.separatorChar;
    private static HashMap<String, String> fileTable = new HashMap();

    public static boolean isAllowConfigUpdate() {
        return BMUnitConfigState.getCurrentConfigState().isAllowConfigUpdate();
    }

    public static boolean isVerbose() {
        return BMUnitConfigState.getCurrentConfigState().isVerbose();
    }

    public static boolean isDebug() {
        return BMUnitConfigState.getCurrentConfigState().isDebug();
    }

    public static boolean isBMUnitVerbose() {
        BMUnitConfigState config = BMUnitConfigState.getCurrentConfigState();
        return config != null && config.isBMUnitVerbose();
    }

    public static String getLoadDirectory() {
        return BMUnitConfigState.getCurrentConfigState().getLoadDirectory();
    }

    public static String getResourceLoadDirectory() {
        return BMUnitConfigState.getCurrentConfigState().getResourceLoadDirectory();
    }

    private static String normalize(String dir, boolean endWithSeparator) {
        int l = dir.length();
        if (l == 0) {
            return dir;
        }
        if (fs == '\\' && dir.indexOf(47, 0) >= 0) {
            dir = dir.replace('/', '\\');
        }
        if (endWithSeparator && dir.charAt(l - 1) != fs) {
            StringBuilder sb = new StringBuilder(l + 1);
            sb.append(dir);
            sb.append(fs);
            return sb.toString();
        }
        return dir;
    }

    public static String getHost() {
        return BMUnitConfigState.getCurrentConfigState().getHost();
    }

    public static int getPort() {
        return BMUnitConfigState.getCurrentConfigState().getPort();
    }

    public static boolean getPolicy() {
        return BMUnitConfigState.getCurrentConfigState().isPolicy();
    }

    public static void loadScriptFile(Class<?> clazz, String dir) throws Exception {
        BMUnit.loadScriptFile(clazz, null, dir);
    }

    public static void loadScriptFile(Class<?> clazz, String testName, String dir) throws Exception {
        if (BMUnitConfigState.getCurrentConfigState() == null) {
            throw new Exception("BMUnit : load script file requested with no current configuration " + clazz.getName() + (testName != null ? " " + testName : "") + (dir != null ? " " + dir : ""));
        }
        String className = clazz.getName();
        if (testName == null) {
            testName = "";
        }
        String key = className + "#" + testName;
        int index = (className = className.replace('.', '/')).lastIndexOf(47);
        String bareClassName = index < 0 ? null : className.substring(index + 1);
        String filename = null;
        File file = null;
        filename = BMUnit.findScript(dir, testName, className + "-" + testName, className, bareClassName, bareClassName + "-" + testName);
        if (filename != null) {
            file = new File(filename);
        }
        if (file == null || !file.exists()) {
            if (BMUnit.isBMUnitVerbose()) {
                System.out.println("BMUnit : failed to find file = " + filename);
            }
            throw new FileNotFoundException("Rule file not found for Byteman test case " + key);
        }
        if (!file.canRead()) {
            if (BMUnit.isBMUnitVerbose()) {
                System.out.println("BMUnit : cannot read file = " + filename);
            }
            throw new IOException("Cannot read Byteman rule file " + filename);
        }
        Submit submit = new Submit(BMUnit.getHost(), BMUnit.getPort());
        ArrayList<String> files = new ArrayList<String>();
        files.add(filename);
        if (BMUnit.isBMUnitVerbose()) {
            System.out.println("BMUnit : loading file script = " + filename);
        }
        submit.addRulesFromFiles(files);
        fileTable.put(key, filename);
    }

    public static void unloadScriptFile(Class<?> clazz, String testName) throws Exception {
        String key;
        String filename;
        String className = clazz.getName();
        if (testName == null) {
            testName = "";
        }
        if ((filename = fileTable.remove(key = className + "#" + testName)) == null) {
            throw new FileNotFoundException("Rule file not found for Byteman test case " + key);
        }
        Submit submit = new Submit(BMUnit.getHost(), BMUnit.getPort());
        ArrayList<String> files = new ArrayList<String>();
        files.add(filename);
        if (BMUnit.isBMUnitVerbose()) {
            System.out.println("BMUnit : unloading file script = " + filename);
        }
        submit.deleteRulesFromFiles(files);
    }

    public static void loadScriptText(Class<?> clazz, String testname, String scriptText) throws Exception {
        if (BMUnitConfigState.getCurrentConfigState() == null) {
            throw new Exception("BMUnit : load script file requested with no current configuration " + clazz.getName() + (testname != null ? " " + testname : ""));
        }
        String className = clazz.getName();
        if (testname == null) {
            testname = "";
        }
        String key = className + "+" + testname;
        fileTable.put(key, scriptText);
        Submit submit = new Submit(BMUnit.getHost(), BMUnit.getPort());
        if (BMUnit.isBMUnitVerbose()) {
            System.out.println("BMUnit : loading text script = " + key);
        }
        ArrayList<ScriptText> scripts = new ArrayList<ScriptText>();
        ScriptText script = new ScriptText(key, scriptText);
        scripts.add(script);
        submit.addScripts(scripts);
    }

    public static void unloadScriptText(Class<?> clazz, String testName) throws Exception {
        String key;
        String scriptText;
        String className = clazz.getName();
        if (testName == null) {
            testName = "";
        }
        if ((scriptText = fileTable.remove(key = className + "+" + testName)) == null) {
            throw new Exception("Rule script not found " + key);
        }
        Submit submit = new Submit(BMUnit.getHost(), BMUnit.getPort());
        if (BMUnit.isBMUnitVerbose()) {
            System.out.println("BMUnit : unloading text script = " + key);
        }
        ArrayList<ScriptText> scripts = new ArrayList<ScriptText>();
        ScriptText script = new ScriptText(key, scriptText);
        scripts.add(script);
        submit.deleteScripts(scripts);
    }

    protected static String findScript(String dir, String name) {
        if (name == null) {
            return null;
        }
        String filename = BMUnit.normalize(name, false);
        String resourceName = name;
        if (dir != null && dir.length() > 0) {
            filename = BMUnit.normalize(dir, true) + filename;
            resourceName = dir + "/" + resourceName;
        } else {
            filename = BMUnit.normalize(BMUnit.getLoadDirectory(), true) + filename;
            String resourceDir = BMUnit.getResourceLoadDirectory();
            if (resourceDir != null && resourceDir.length() > 0) {
                String separator = resourceDir.endsWith("/") ? "" : "/";
                resourceName = resourceDir + separator + resourceName;
            }
        }
        String[] filenames = new String[]{filename, filename + ".btm", filename + ".txt"};
        String[] resourceNames = new String[]{resourceName, resourceName + ".btm", resourceName + ".txt"};
        for (String fname : filenames) {
            File file = new File(fname);
            if (!file.exists() || !file.isFile()) continue;
            return fname;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        for (String rname : resourceNames) {
            File file;
            URL resource = loader.getResource(rname);
            if (resource == null || !(file = new File(resource.getFile())).exists() || !file.isFile()) continue;
            return resource.getFile();
        }
        return null;
    }

    protected static String findScript(String dir, String ... names) {
        for (String name : names) {
            String filename = BMUnit.findScript(dir, name);
            if (filename == null) continue;
            return filename;
        }
        return null;
    }
}

